/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.mediators.builtin.ForEachMediator;

public class ForEachMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    public String getMediatorClassName() {
        return ForEachMediator.class.getName();
    }

    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof ForEachMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        OMElement forEachElem = fac.createOMElement("foreach", synNS);
        ForEachMediatorSerializer.saveTracingState(forEachElem, m);
        ForEachMediator forEachMed = (ForEachMediator)m;
        if (forEachMed.getId() != null) {
            forEachElem.addAttribute("id", forEachMed.getId(), nullNS);
        }
        if (forEachMed.getExpression() != null) {
            SynapsePathSerializer.serializePath(forEachMed.getExpression(), forEachElem, "expression");
        } else {
            this.handleException("Missing expression of the ForEach which is required.");
        }
        if (forEachMed.getSequenceRef() != null) {
            forEachElem.addAttribute("sequence", forEachMed.getSequenceRef(), null);
        } else if (forEachMed.getSequence() != null) {
            SequenceMediatorSerializer seqSerializer = new SequenceMediatorSerializer();
            OMElement seqElement = seqSerializer.serializeAnonymousSequence(null, forEachMed.getSequence());
            seqElement.setLocalName("sequence");
            forEachElem.addChild((OMNode)seqElement);
        }
        this.serializeComments(forEachElem, forEachMed.getCommentsList());
        return forEachElem;
    }
}

