/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.CallMediator;
import org.apache.synapse.mediators.builtin.CalloutMediator;
import org.apache.synapse.mediators.builtin.ForEachMediator;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.jaxen.JaxenException;

public class ForEachMediatorFactory
extends AbstractMediatorFactory {
    private static final QName FOREACH_Q = new QName("http://ws.apache.org/ns/synapse", "foreach");
    private static final QName ID_Q = new QName("", "id");

    @Override
    public QName getTagQName() {
        return FOREACH_Q;
    }

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute expression;
        ForEachMediator mediator = new ForEachMediator();
        this.processAuditStatus(mediator, elem);
        OMAttribute id = elem.getAttribute(ID_Q);
        if (id != null) {
            mediator.setId(id.getAttributeValue());
        }
        if ((expression = elem.getAttribute(ATT_EXPRN)) != null) {
            try {
                mediator.setExpression(SynapsePathFactory.getSynapsePath(elem, ATT_EXPRN));
            }
            catch (JaxenException e) {
                this.handleException("Unable to build the ForEach Mediator. Invalid XPath/JSONPath " + expression.getAttributeValue(), (Exception)((Object)e));
            }
        } else {
            this.handleException("XPath/JSONPath expression is required for an ForEach Mediator under the \"expression\" attribute");
        }
        OMAttribute sequenceAttr = elem.getAttribute(new QName("", "sequence"));
        if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
            mediator.setSequenceRef(sequenceAttr.getAttributeValue());
        } else {
            OMElement sequence = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
            if (sequence != null) {
                SequenceMediatorFactory fac = new SequenceMediatorFactory();
                SequenceMediator sequenceMediator = fac.createAnonymousSequence(sequence, properties);
                if (this.validateSequence(sequenceMediator)) {
                    mediator.setSequence(sequenceMediator);
                } else {
                    this.handleException("Sequence cannot contain Call, Send or CallOut mediators");
                }
            }
        }
        ForEachMediatorFactory.addAllCommentChildrenToList(elem, mediator.getCommentsList());
        return mediator;
    }

    private boolean validateSequence(SequenceMediator sequence) {
        if (sequence != null) {
            List<Mediator> mediators = sequence.getList();
            for (Mediator m : mediators) {
                if (!(m instanceof CallMediator) && !(m instanceof CalloutMediator) && !(m instanceof SendMediator)) continue;
                return false;
            }
        }
        return true;
    }
}

