/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.elementary.EnrichMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.util.InlineExpressionUtil;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.jaxen.JaxenException;

public class EnrichMediatorFactory
extends AbstractMediatorFactory {
    private static final QName XML_Q = new QName("http://ws.apache.org/ns/synapse", "enrich");
    private static final QName ATT_PROPERTY = new QName("property");
    private static final QName ATT_XPATH = new QName("xpath");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_CLONE = new QName("clone");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_KEY = new QName("key");
    public static final QName SOURCE_Q = new QName("http://ws.apache.org/ns/synapse", "source");
    public static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    public static final String CUSTOM = "custom";
    public static final String PROPERTY = "property";
    public static final String ENVELOPE = "envelope";
    public static final String BODY = "body";
    public static final String INLINE = "inline";
    public static final String KEY = "key";

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        if (!XML_Q.equals(elem.getQName())) {
            this.handleException("Unable to create the enrich mediator. Unexpected element as the enrich mediator configuration");
        }
        EnrichMediator enrich = new EnrichMediator();
        this.processAuditStatus(enrich, elem);
        OMElement sourceEle = elem.getFirstChildWithName(SOURCE_Q);
        if (sourceEle == null) {
            this.handleException("source element is mandatory");
        }
        Source source = new Source();
        enrich.setSource(source);
        OMElement targetEle = elem.getFirstChildWithName(TARGET_Q);
        if (targetEle == null) {
            this.handleException("target element is mandatory");
        }
        Target target = new Target();
        enrich.setTarget(target);
        this.validateTypeCombination(sourceEle, targetEle);
        this.populateSource(source, sourceEle);
        this.populateTarget(target, targetEle);
        boolean isInlineSourceXML = false;
        String inlineString = null;
        if (source.getInlineOMNode() != null) {
            block13: {
                if (source.getInlineOMNode() instanceof OMText) {
                    inlineString = ((OMTextImpl)source.getInlineOMNode()).getText();
                    JsonParser parser = new JsonParser();
                    try {
                        JsonElement element = parser.parse(inlineString);
                        if (!(element instanceof JsonObject || element instanceof JsonArray || element instanceof JsonPrimitive)) {
                            isInlineSourceXML = true;
                        }
                        break block13;
                    }
                    catch (JsonSyntaxException ex) {
                        if (!inlineString.trim().startsWith("{") || !inlineString.trim().endsWith("}")) {
                            isInlineSourceXML = true;
                        }
                        break block13;
                    }
                }
                if (source.getInlineOMNode() instanceof OMElement) {
                    inlineString = ((OMElement)source.getInlineOMNode()).getText();
                    isInlineSourceXML = true;
                }
            }
            if (!StringUtils.isEmpty((String)inlineString)) {
                enrich.setContainsInlineExpressions(InlineExpressionUtil.checkForInlineExpressions(inlineString));
            }
        }
        boolean sourceHasCustom = source.getSourceType() == 0;
        boolean targetHasCustom = target.getTargetType() == 0;
        boolean enrichHasCustom = sourceHasCustom || targetHasCustom;
        boolean sourceHasEnvelope = source.getSourceType() == 1;
        boolean targetHasEnvelope = target.getTargetType() == 1;
        boolean enrichHasEnvelope = sourceHasEnvelope || targetHasEnvelope;
        boolean sourceHasACustomJsonPath = false;
        boolean targetHasACustomJsonPath = false;
        if (sourceHasCustom) {
            sourceHasACustomJsonPath = "JSON_PATH".equals(source.getXpath().getPathType());
        }
        if (targetHasCustom) {
            targetHasACustomJsonPath = "JSON_PATH".equals(target.getXpath().getPathType());
        }
        boolean condition1 = !enrichHasCustom;
        boolean condition2 = sourceHasACustomJsonPath && !targetHasCustom;
        boolean condition3 = !sourceHasCustom && targetHasACustomJsonPath;
        boolean condition4 = sourceHasACustomJsonPath && targetHasACustomJsonPath;
        boolean condition5 = !enrichHasEnvelope;
        enrich.setNativeJsonSupportEnabled(!isInlineSourceXML && condition5 && (condition1 || condition2 || condition3 || condition4));
        EnrichMediatorFactory.addAllCommentChildrenToList(elem, enrich.getCommentsList());
        return enrich;
    }

    private void populateSource(Source source, OMElement sourceEle) {
        OMAttribute cloneAttr;
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            source.setSourceType(this.convertTypeToInt(typeAttr.getAttributeValue()));
        }
        if ((cloneAttr = sourceEle.getAttribute(ATT_CLONE)) != null && cloneAttr.getAttributeValue() != null) {
            source.setClone(Boolean.parseBoolean(cloneAttr.getAttributeValue()));
        }
        if (source.getSourceType() == 0) {
            OMAttribute xpathAttr = sourceEle.getAttribute(ATT_XPATH);
            if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                try {
                    source.setXpath(SynapsePathFactory.getSynapsePath(sourceEle, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathAttr);
                }
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (source.getSourceType() == 3) {
            OMAttribute propertyAttr = sourceEle.getAttribute(ATT_PROPERTY);
            if (propertyAttr != null && propertyAttr.getAttributeValue() != null) {
                source.setProperty(propertyAttr.getAttributeValue());
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (source.getSourceType() == 4) {
            OMElement inlineElem = null;
            if (sourceEle.getFirstElement() != null) {
                inlineElem = sourceEle.getFirstElement().cloneOMElement();
            }
            if (inlineElem != null) {
                source.setInlineOMNode((OMNode)inlineElem);
            } else if (!StringUtils.isBlank((String)sourceEle.getText())) {
                source.setInlineOMNode((OMNode)OMAbstractFactory.getOMFactory().createOMText(sourceEle.getText()));
            } else if (sourceEle.getAttributeValue(ATT_KEY) != null) {
                source.setInlineKey(sourceEle.getAttributeValue(ATT_KEY));
            } else {
                this.handleException("XML element is required for INLINE type");
            }
        }
    }

    private void populateTarget(Target target, OMElement sourceEle) {
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        OMAttribute actionAttr = sourceEle.getAttribute(ATT_ACTION);
        if (actionAttr != null && actionAttr.getAttributeValue() != null) {
            target.setAction(actionAttr.getAttributeValue());
        } else {
            target.setAction("replace");
        }
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            int type = this.convertTypeToInt(typeAttr.getAttributeValue());
            if (type >= 0) {
                target.setTargetType(type);
                if (type == 1 && !target.getAction().equals("replace")) {
                    throw new SynapseException("Invalid target action");
                }
            } else {
                this.handleException("Un-expected type : " + typeAttr.getAttributeValue());
            }
        }
        if (target.getTargetType() == 0) {
            OMAttribute xpathAttr = sourceEle.getAttribute(ATT_XPATH);
            if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                try {
                    target.setXpath(SynapsePathFactory.getSynapsePath(sourceEle, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathAttr);
                }
                SynapsePath targetXPath = target.getXpath();
                if (target.getAction().equals("replace") && targetXPath instanceof SynapseJsonPath && ("$".equals(((SynapseJsonPath)targetXPath).expression) || "$.".equals(((SynapseJsonPath)targetXPath).expression))) {
                    this.handleException("Acting replace is not supported for root path in type custom. Please use type body action replace instead");
                }
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (target.getTargetType() == 3) {
            OMAttribute propertyAttr = sourceEle.getAttribute(ATT_PROPERTY);
            if (propertyAttr != null && propertyAttr.getAttributeValue() != null) {
                target.setProperty(propertyAttr.getAttributeValue());
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (target.getTargetType() == 5) {
            OMAttribute xpathAttr = sourceEle.getAttribute(ATT_XPATH);
            if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                try {
                    target.setXpath(SynapsePathFactory.getSynapsePath(sourceEle, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathAttr);
                }
                if (!target.getAction().equals("replace")) {
                    this.handleException("Only the replace action is supported for the target type 'key'.");
                }
            } else {
                this.handleException("Xpath must be defined for the target type 'key'.");
            }
        }
    }

    private int convertTypeToInt(String type) {
        if (type.equals(ENVELOPE)) {
            return 1;
        }
        if (type.equals(BODY)) {
            return 2;
        }
        if (type.equals(PROPERTY)) {
            return 3;
        }
        if (type.equals(CUSTOM)) {
            return 0;
        }
        if (type.equals(INLINE)) {
            return 4;
        }
        if (type.equals(KEY)) {
            return 5;
        }
        return -1;
    }

    private int convertActionToInt(String action) {
        switch (action) {
            case "replace": {
                return 0;
            }
            case "child": {
                return 1;
            }
            case "sibling": {
                return 2;
            }
            case "remove": {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public QName getTagQName() {
        return XML_Q;
    }

    private void validateTypeCombination(OMElement sourceElement, OMElement targetElement) {
        OMAttribute targetTypeAttr;
        int sourceType = -1;
        int targetType = -1;
        int targetAction = -1;
        OMAttribute sourceTypeAttr = sourceElement.getAttribute(ATT_TYPE);
        if (sourceTypeAttr != null && sourceTypeAttr.getAttributeValue() != null) {
            sourceType = this.convertTypeToInt(sourceTypeAttr.getAttributeValue());
            if (sourceType < 0) {
                throw new SynapseException("Unexpected source type");
            }
        } else {
            sourceType = 0;
        }
        if ((targetTypeAttr = targetElement.getAttribute(ATT_TYPE)) != null && targetTypeAttr.getAttributeValue() != null) {
            targetType = this.convertTypeToInt(targetTypeAttr.getAttributeValue());
            if (targetType < 0) {
                throw new SynapseException("Unexpected target type");
            }
            if (targetType == 4) {
                throw new SynapseException("Inline not support for target attribute");
            }
        }
        if (sourceType == 1 ? targetType == 0 || targetType == 1 || targetType == 2 : (sourceType == 2 ? targetType == 1 || targetType == 2 : sourceType == 0 && targetType == 1)) {
            throw new SynapseException("Wrong combination of source and target type");
        }
        OMAttribute targetActionAttr = targetElement.getAttribute(ATT_ACTION);
        if (targetActionAttr != null && targetActionAttr.getAttributeValue() != null && (targetAction = this.convertActionToInt(targetActionAttr.getAttributeValue())) < 0) {
            throw new SynapseException("Unexpected target action");
        }
        if (targetAction == 3) {
            if (sourceType != 0) {
                throw new SynapseException("Wrong combination of source type and target action");
            }
            if (targetType == 0 || targetType == 1 || targetType == 4) {
                throw new SynapseException("Wrong combination of target type and target action");
            }
        }
        if (targetType == 5) {
            if (sourceType == 2) {
                throw new SynapseException("Wrong combination of source type and target type");
            }
            if (targetAction != 0) {
                throw new SynapseException("Wrong combination of target type and target action");
            }
        }
    }
}

