/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.TargetFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.eip.splitter.CloneMediator;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CloneMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CLONE_Q = new QName("http://ws.apache.org/ns/synapse", "clone");
    private static final QName ATT_CONTINUE_PARENT = new QName("continueParent");
    private static final QName ATT_ITERATIONS = new QName("iterations");
    private static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    private static final QName ID_Q = new QName("", "id");
    private static final QName SEQUENTIAL_Q = new QName("sequential");
    private static final String ITERATIONS = "iterations";

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute synchronousExeAttr;
        OMAttribute iterations;
        OMAttribute continueParent;
        boolean asynchronousExe = true;
        CloneMediator mediator = new CloneMediator();
        this.processAuditStatus(mediator, elem);
        OMAttribute id = elem.getAttribute(ID_Q);
        if (id != null) {
            mediator.setId(id.getAttributeValue());
        }
        if ((continueParent = elem.getAttribute(ATT_CONTINUE_PARENT)) != null) {
            mediator.setContinueParent(JavaUtils.isTrueExplicitly((String)continueParent.getAttributeValue()));
        }
        if ((iterations = elem.getAttribute(ATT_ITERATIONS)) != null) {
            String iterationsAttributeStr = iterations.getAttributeValue();
            if (this.isDynamicValue(iterationsAttributeStr)) {
                Value iterationsAttributeValue = this.resolveDynamicAttribute(iterationsAttributeStr, elem);
                mediator.setDynamicIterationsValue(iterationsAttributeValue);
            }
            mediator.setIterations(iterationsAttributeStr);
        }
        if ((synchronousExeAttr = elem.getAttribute(SEQUENTIAL_Q)) != null && synchronousExeAttr.getAttributeValue().equals("true")) {
            asynchronousExe = false;
        }
        mediator.setSequential(!asynchronousExe);
        Iterator targetElements = elem.getChildrenWithName(TARGET_Q);
        int noOfTargets = 0;
        while (targetElements.hasNext()) {
            Target target = TargetFactory.createTarget((OMElement)targetElements.next(), properties);
            target.setAsynchronous(asynchronousExe);
            mediator.addTarget(target);
            ++noOfTargets;
        }
        if (iterations != null && noOfTargets > 1) {
            this.handleException("When iterations attribute is defined only one target is allowed.");
        }
        CloneMediatorFactory.addAllCommentChildrenToList(elem, mediator.getCommentsList());
        return mediator;
    }

    private Value resolveDynamicAttribute(String attributeValue, OMElement elem) {
        try {
            String valueExpression = attributeValue.substring(1, attributeValue.length() - 1);
            if (valueExpression.startsWith("json-eval(")) {
                new SynapseJsonPath(valueExpression.substring(10, valueExpression.length() - 1));
            } else {
                new SynapseXPath(valueExpression);
            }
        }
        catch (JaxenException e) {
            this.handleException("Invalid expression for attribute 'name' : " + attributeValue);
        }
        ValueFactory nameValueFactory = new ValueFactory();
        return nameValueFactory.createValue(ITERATIONS, elem);
    }

    private boolean isDynamicValue(String nameValue) {
        if (nameValue.length() < 2) {
            return false;
        }
        int startExpression = 123;
        int endExpression = 125;
        char firstChar = nameValue.charAt(0);
        char lastChar = nameValue.charAt(nameValue.length() - 1);
        return '{' == firstChar && '}' == lastChar;
    }

    @Override
    public QName getTagQName() {
        return CLONE_Q;
    }
}

