/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.mediators.ext.ClassMediator;

public class ClassMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CLASS_Q = new QName("http://ws.apache.org/ns/synapse", "class");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        Mediator mediator;
        String msg;
        ClassMediator classMediator = new ClassMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        if (name == null) {
            String msg2 = "The name of the actual mediator class is a required attribute";
            log.error((Object)msg2);
            throw new SynapseException(msg2);
        }
        Class<?> clazz = null;
        if (properties != null) {
            ClassLoader libLoader = (ClassLoader)properties.get("synapse.lib.classloader");
            if (libLoader != null) {
                try {
                    clazz = libLoader.loadClass(name.getAttributeValue());
                }
                catch (ClassNotFoundException e) {
                    String msg3 = "Error loading class : " + name.getAttributeValue() + " from Synapse library";
                    log.error((Object)msg3, (Throwable)e);
                    throw new SynapseException(msg3, e);
                }
            } else {
                Map dynamicClassMediatorLoaderMap = (Map)properties.get("CLASS_MEDIATOR_LOADERS");
                if (dynamicClassMediatorLoaderMap != null) {
                    Iterator dynamicClassMediatorLoaders = dynamicClassMediatorLoaderMap.values().iterator();
                    while (dynamicClassMediatorLoaders.hasNext()) {
                        try {
                            clazz = ((ClassLoader)dynamicClassMediatorLoaders.next()).loadClass(name.getAttributeValue());
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
        }
        if (clazz == null) {
            try {
                clazz = this.getClass().getClassLoader().loadClass(name.getAttributeValue());
            }
            catch (ClassNotFoundException e) {
                msg = "Error loading class : " + name.getAttributeValue() + " - Class not found";
                log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
        }
        try {
            mediator = (Mediator)clazz.newInstance();
        }
        catch (Throwable e) {
            msg = "Error in instantiating class : " + name.getAttributeValue();
            log.error((Object)msg, e);
            throw new SynapseException(msg, e);
        }
        classMediator.addAllProperties(MediatorPropertyFactory.getMediatorProperties(elem, mediator));
        classMediator.setMediator(mediator);
        this.processAuditStatus(classMediator, elem);
        ClassMediatorFactory.addAllCommentChildrenToList(elem, classMediator.getCommentsList());
        return classMediator;
    }

    @Override
    public QName getTagQName() {
        return CLASS_Q;
    }
}

