/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.builtin.CallMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;

public class CallMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof CallMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        CallMediator mediator = (CallMediator)m;
        OMElement call = fac.createOMElement("call", synNS);
        CallMediatorSerializer.saveTracingState(call, mediator);
        Endpoint activeEndpoint = mediator.getEndpoint();
        if (activeEndpoint != null) {
            call.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(activeEndpoint));
        }
        if (mediator.isBlocking()) {
            call.addAttribute(fac.createOMAttribute("blocking", nullNS, "true"));
            if (!mediator.getInitClientOptions()) {
                call.addAttribute(fac.createOMAttribute("initAxis2ClientOptions", nullNS, "false"));
            }
            if (mediator.getClientRepository() != null) {
                call.addAttribute(fac.createOMAttribute("repository", nullNS, mediator.getClientRepository()));
            }
            if (mediator.getAxis2xml() != null) {
                call.addAttribute(fac.createOMAttribute("axis2xml", nullNS, mediator.getAxis2xml()));
            }
        }
        if (mediator.isSourceAvailable()) {
            OMElement sourceEle = this.serializeSource(mediator);
            call.addChild((OMNode)sourceEle);
        }
        if (mediator.isTargetAvailable()) {
            OMElement targetEle = this.serializeTarget(mediator.getTargetForInboundPayload());
            call.addChild((OMNode)targetEle);
        }
        this.serializeComments(call, mediator.getCommentsList());
        return call;
    }

    private OMElement serializeSource(CallMediator mediator) {
        Source source = mediator.getSourceForOutboundPayload();
        String sourceContentType = mediator.getSourceMessageType();
        OMElement sourceEle = fac.createOMElement("source", synNS);
        sourceEle.addAttribute(fac.createOMAttribute("type", nullNS, this.intTypeToString(source.getSourceType())));
        if (sourceContentType != null) {
            sourceEle.addAttribute(fac.createOMAttribute("contentType", nullNS, sourceContentType));
        }
        if (source.getSourceType() == 3) {
            sourceEle.setText(source.getProperty());
        } else if (source.getSourceType() == 0) {
            sourceEle.setText(source.getXpath().toString());
        } else if (source.getSourceType() == 4) {
            if (source.getInlineOMNode() instanceof OMElement) {
                sourceEle.addChild((OMNode)((OMElement)source.getInlineOMNode()).cloneOMElement());
            } else if (source.getInlineOMNode() instanceof OMText) {
                sourceEle.setText(((OMText)source.getInlineOMNode()).getText());
            }
        }
        return sourceEle;
    }

    private OMElement serializeTarget(Target target) {
        OMElement targetEle = fac.createOMElement("target", synNS);
        targetEle.addAttribute(fac.createOMAttribute("type", nullNS, this.intTypeToString(target.getTargetType())));
        if (target.getTargetType() == 3) {
            targetEle.setText(target.getProperty());
        }
        return targetEle;
    }

    private String intTypeToString(int type) {
        if (type == 0) {
            return "custom";
        }
        if (type == 2) {
            return "body";
        }
        if (type == 3) {
            return "property";
        }
        if (type == 4) {
            return "inline";
        }
        return null;
    }

    @Override
    public String getMediatorClassName() {
        return CallMediator.class.getName();
    }
}

