/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.File;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.builtin.CallMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.util.CallMediatorEnrichUtil;
import org.jaxen.JaxenException;

public class CallMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CALL_Q = new QName("http://ws.apache.org/ns/synapse", "call");
    private static final QName ENDPOINT_Q = new QName("http://ws.apache.org/ns/synapse", "endpoint");
    private static final QName BLOCKING_Q = new QName("blocking");
    private static final QName ATT_INIT_AXIS2_CLIENT_OPTIONS = new QName("initAxis2ClientOptions");
    private static final QName ATT_AXIS2XML = new QName("axis2xml");
    private static final QName ATT_REPOSITORY = new QName("repository");
    public static final QName SOURCE_Q = new QName("http://ws.apache.org/ns/synapse", "source");
    public static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName CONTENT_TYPE = new QName("contentType");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute blockingAtt;
        Endpoint endpoint;
        OMElement epElement;
        OMElement targetEle;
        CallMediator callMediator = new CallMediator();
        this.processAuditStatus(callMediator, elem);
        OMElement sourceEle = elem.getFirstChildWithName(SOURCE_Q);
        if (sourceEle != null) {
            Source source = new Source();
            this.populateSource(callMediator, source, sourceEle);
            callMediator.setSourceForOutboundPayload(source);
        }
        if ((targetEle = elem.getFirstChildWithName(TARGET_Q)) != null) {
            Target target = new Target();
            this.populateTarget(callMediator, target, targetEle);
            callMediator.setTargetForInboundPayload(target);
        }
        if ((epElement = elem.getFirstChildWithName(ENDPOINT_Q)) != null && (endpoint = EndpointFactory.getEndpointFromElement(epElement, true, properties)) != null) {
            callMediator.setEndpoint(endpoint);
        }
        if ((blockingAtt = elem.getAttribute(BLOCKING_Q)) != null) {
            callMediator.setBlocking(Boolean.parseBoolean(blockingAtt.getAttributeValue()));
            if (callMediator.isBlocking()) {
                OMAttribute initAxis2ClientOptions = elem.getAttribute(ATT_INIT_AXIS2_CLIENT_OPTIONS);
                OMAttribute axis2xmlAttr = elem.getAttribute(ATT_AXIS2XML);
                OMAttribute repoAttr = elem.getAttribute(ATT_REPOSITORY);
                if (initAxis2ClientOptions != null) {
                    callMediator.setInitClientOptions(Boolean.parseBoolean(initAxis2ClientOptions.getAttributeValue()));
                }
                if (axis2xmlAttr != null && axis2xmlAttr.getAttributeValue() != null) {
                    File axis2xml = new File(axis2xmlAttr.getAttributeValue());
                    if (axis2xml.exists() && axis2xml.isFile()) {
                        callMediator.setAxis2xml(axis2xmlAttr.getAttributeValue());
                    } else {
                        this.handleException("Invalid axis2.xml path: " + axis2xmlAttr.getAttributeValue());
                    }
                }
                if (repoAttr != null && repoAttr.getAttributeValue() != null) {
                    File repo = new File(repoAttr.getAttributeValue());
                    if (repo.exists() && repo.isDirectory()) {
                        callMediator.setClientRepository(repoAttr.getAttributeValue());
                    } else {
                        this.handleException("Invalid repository path: " + repoAttr.getAttributeValue());
                    }
                }
            }
        }
        CallMediatorFactory.addAllCommentChildrenToList(elem, callMediator.getCommentsList());
        return callMediator;
    }

    private void populateSource(CallMediator callMediator, Source source, OMElement sourceEle) {
        OMAttribute contentTypeAtt;
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            source.setSourceType(CallMediatorEnrichUtil.convertTypeToInt(typeAttr.getAttributeValue()));
        }
        if ((contentTypeAtt = sourceEle.getAttribute(CONTENT_TYPE)) != null && contentTypeAtt.getAttributeValue() != null) {
            callMediator.setSourceMessageType(contentTypeAtt.getAttributeValue());
        }
        source.setClone(false);
        if (source.getSourceType() == 0) {
            String xpathExpressionElement = sourceEle.getText();
            if (xpathExpressionElement != null) {
                try {
                    source.setXpath(SynapsePathFactory.getSynapsePathfromExpression(sourceEle, xpathExpressionElement));
                    callMediator.setSourceAvailable(true);
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathExpressionElement);
                }
            } else {
                this.handleException("Xpath attribute is required for CUSTOM type");
            }
        } else if (source.getSourceType() == 3) {
            String propertyValue = sourceEle.getText();
            if (propertyValue != null) {
                source.setProperty(propertyValue);
                callMediator.setSourceAvailable(true);
            } else {
                this.handleException("Property value is required for PROPERTY type");
            }
        } else if (source.getSourceType() == 4) {
            OMElement inlineElem = null;
            if (sourceEle.getFirstElement() != null) {
                inlineElem = sourceEle.getFirstElement().cloneOMElement();
            }
            if (inlineElem != null) {
                source.setInlineOMNode((OMNode)inlineElem);
            } else if (!StringUtils.isBlank((String)sourceEle.getText())) {
                source.setInlineOMNode((OMNode)OMAbstractFactory.getOMFactory().createOMText(sourceEle.getText()));
            } else {
                this.handleException("XML element is required for INLINE type");
            }
            callMediator.setSourceAvailable(true);
        } else if (source.getSourceType() == 2) {
            callMediator.setSourceAvailable(false);
        }
    }

    private void populateTarget(CallMediator callMediator, Target target, OMElement sourceEle) {
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        target.setAction("replace");
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            int type = CallMediatorEnrichUtil.convertTypeToInt(typeAttr.getAttributeValue());
            if (type >= 0) {
                target.setTargetType(type);
            } else {
                this.handleException("Un-expected type : " + typeAttr.getAttributeValue());
            }
        }
        if (target.getTargetType() == 3) {
            String propertyName = sourceEle.getText();
            if (propertyName != null) {
                target.setProperty(propertyName);
                callMediator.setTargetAvailable(true);
            } else {
                this.handleException("Property name is required for PROPERTY type");
            }
        } else if (target.getTargetType() == 2) {
            callMediator.setTargetAvailable(false);
        }
    }

    @Override
    public QName getTagQName() {
        return CALL_Q;
    }
}

