/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.bean.BeanMediator;
import org.apache.synapse.mediators.bean.Target;

public class BeanMediatorFactory
extends AbstractMediatorFactory {
    private static final QName BEAN_Q = new QName("http://ws.apache.org/ns/synapse", "bean");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        BeanMediator mediator = new BeanMediator();
        this.processAuditStatus(mediator, elem);
        String attributeValue = elem.getAttributeValue(new QName("var"));
        if (attributeValue != null) {
            mediator.setVarName(attributeValue);
        } else {
            this.handleException("'var' attribute of Bean mediator is required.");
        }
        attributeValue = elem.getAttributeValue(new QName("action"));
        if (attributeValue != null) {
            try {
                switch (BeanMediator.Action.valueOf(attributeValue.toUpperCase())) {
                    case CREATE: {
                        this.populateCreateBeanCase(mediator, elem);
                        break;
                    }
                    case REMOVE: {
                        mediator.setAction(BeanMediator.Action.REMOVE);
                        break;
                    }
                    case SET_PROPERTY: {
                        this.populateSetPropertyCase(mediator, elem);
                        break;
                    }
                    case GET_PROPERTY: {
                        this.populateGetPropertyCase(mediator, elem);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.handleException("'action' attribute of bean mediator must be set to 'CREATE', 'REMOVE', 'SET_PROPERTY' or 'GET_PROPERTY'.");
            }
        } else {
            this.handleException("'action' attribute of Bean mediator is required.");
        }
        BeanMediatorFactory.addAllCommentChildrenToList(elem, mediator.getCommentsList());
        return mediator;
    }

    private void populateCreateBeanCase(BeanMediator mediator, OMElement elem) {
        mediator.setAction(BeanMediator.Action.CREATE);
        String attributeValue = elem.getAttributeValue(new QName("class"));
        if (attributeValue != null) {
            try {
                mediator.setClazz(Class.forName(attributeValue.trim()));
            }
            catch (Exception e) {
                this.handleException("Error while loading '" + attributeValue + "' class.", e);
            }
        } else {
            this.handleException("'class' attribute of Bean mediator is required when 'CREATE' action is set.");
        }
        attributeValue = elem.getAttributeValue(new QName("replace"));
        if (attributeValue != null) {
            mediator.setReplace(Boolean.parseBoolean(attributeValue.trim()));
        }
    }

    private void populateSetPropertyCase(BeanMediator mediator, OMElement elem) {
        mediator.setAction(BeanMediator.Action.SET_PROPERTY);
        this.populatePropertyName(mediator, elem);
        if (elem.getAttributeValue(ATT_VALUE) != null) {
            mediator.setValue(new ValueFactory().createValue("value", elem));
        } else {
            this.handleException("'value' attribute of Bean mediator is required when 'SET_PROPERTY' action is set.");
        }
    }

    private void populateGetPropertyCase(BeanMediator mediator, OMElement elem) {
        mediator.setAction(BeanMediator.Action.GET_PROPERTY);
        this.populatePropertyName(mediator, elem);
        if (elem.getAttributeValue(new QName("target")) != null) {
            mediator.setTarget(new Target("target", elem));
        } else {
            this.handleException("'target' attribute of Bean mediator is required when 'GET_PROPERTY' action is set.");
        }
    }

    private void populatePropertyName(BeanMediator mediator, OMElement elem) {
        String attributeValue = elem.getAttributeValue(new QName("property"));
        if (attributeValue != null) {
            mediator.setPropertyName(attributeValue);
        } else {
            this.handleException("'property' attribute of Bean mediator is required when SET/GET_PROPERTY action is set.");
        }
    }

    @Override
    public QName getTagQName() {
        return BEAN_Q;
    }
}

