/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;
import org.jaxen.JaxenException;

public class AggregateMediatorFactory
extends AbstractMediatorFactory {
    protected static final QName AGGREGATE_Q = new QName("http://ws.apache.org/ns/synapse", "aggregate");
    protected static final QName CORELATE_ON_Q = new QName("http://ws.apache.org/ns/synapse", "correlateOn");
    protected static final QName COMPLETE_CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "completeCondition");
    protected static final QName MESSAGE_COUNT_Q = new QName("http://ws.apache.org/ns/synapse", "messageCount");
    protected static final QName ON_COMPLETE_Q = new QName("http://ws.apache.org/ns/synapse", "onComplete");
    private static final QName EXPRESSION_Q = new QName("", "expression");
    private static final QName TIMEOUT_Q = new QName("", "timeout");
    private static final QName MIN_Q = new QName("", "min");
    private static final QName MAX_Q = new QName("", "max");
    private static final QName SEQUENCE_Q = new QName("", "sequence");
    private static final QName ID_Q = new QName("", "id");
    private static final QName ENCLOSING_ELEMENT_PROPERTY = new QName("", "enclosingElementProperty");
    private static final QName AGGREGATE_ELEMENT_TYPE = new QName("", "aggregateElementType");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMElement onComplete;
        OMElement completeCond;
        OMAttribute corelateExpr;
        OMElement corelateOn;
        AggregateMediator mediator = new AggregateMediator();
        this.processAuditStatus(mediator, elem);
        OMAttribute id = elem.getAttribute(ID_Q);
        if (id != null) {
            mediator.setId(id.getAttributeValue());
        }
        if ((corelateOn = elem.getFirstChildWithName(CORELATE_ON_Q)) != null && (corelateExpr = corelateOn.getAttribute(EXPRESSION_Q)) != null) {
            try {
                mediator.setCorrelateExpression(SynapsePathFactory.getSynapsePath(corelateOn, EXPRESSION_Q));
            }
            catch (JaxenException e) {
                this.handleException("Unable to load the corelate XPATH expression", (Exception)((Object)e));
            }
        }
        if ((completeCond = elem.getFirstChildWithName(COMPLETE_CONDITION_Q)) != null) {
            OMElement messageCount;
            OMAttribute completeTimeout = completeCond.getAttribute(TIMEOUT_Q);
            if (completeTimeout != null) {
                mediator.setCompletionTimeoutMillis(Long.parseLong(completeTimeout.getAttributeValue()) * 1000L);
            }
            if ((messageCount = completeCond.getFirstChildWithName(MESSAGE_COUNT_Q)) != null) {
                OMAttribute max;
                OMAttribute min = messageCount.getAttribute(MIN_Q);
                if (min != null) {
                    mediator.setMinMessagesToComplete(new ValueFactory().createValue("min", messageCount));
                }
                if ((max = messageCount.getAttribute(MAX_Q)) != null) {
                    mediator.setMaxMessagesToComplete(new ValueFactory().createValue("max", messageCount));
                }
            }
        }
        if ((onComplete = elem.getFirstChildWithName(ON_COMPLETE_Q)) != null) {
            OMAttribute onCompleteSequence;
            OMAttribute enclosingElementPropertyName;
            OMAttribute aggregateExpr;
            OMAttribute aggregateElementType = onComplete.getAttribute(AGGREGATE_ELEMENT_TYPE);
            if (aggregateElementType != null) {
                mediator.setAggregateElementType(new ValueFactory().createValue("aggregateElementType", onComplete));
            }
            if ((aggregateExpr = onComplete.getAttribute(EXPRESSION_Q)) != null) {
                try {
                    mediator.setAggregationExpression(SynapsePathFactory.getSynapsePath(onComplete, EXPRESSION_Q));
                }
                catch (JaxenException e) {
                    this.handleException("Unable to load the aggregating XPATH", (Exception)((Object)e));
                }
            }
            if ((enclosingElementPropertyName = onComplete.getAttribute(ENCLOSING_ELEMENT_PROPERTY)) != null) {
                mediator.setEnclosingElementPropertyName(enclosingElementPropertyName.getAttributeValue());
            }
            if ((onCompleteSequence = onComplete.getAttribute(SEQUENCE_Q)) != null) {
                mediator.setOnCompleteSequenceRef(onCompleteSequence.getAttributeValue());
            } else if (onComplete.getFirstElement() != null) {
                mediator.setOnCompleteSequence(new SequenceMediatorFactory().createAnonymousSequence(onComplete, properties));
            } else {
                SequenceMediator sequence = new SequenceMediator();
                sequence.addChild(new DropMediator());
                mediator.setOnCompleteSequence(sequence);
            }
        }
        AggregateMediatorFactory.addAllCommentChildrenToList(elem, mediator.getCommentsList());
        return mediator;
    }

    @Override
    public QName getTagQName() {
        return AGGREGATE_Q;
    }
}

