/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Nameable;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.xml.MediatorFactory;

public abstract class AbstractMediatorFactory
implements MediatorFactory {
    static Log log;
    protected static final QName ATT_NAME;
    protected static final QName ATT_VALUE;
    protected static final QName ATT_DESCRIPTION;
    protected static final QName ATT_IS_MANDATORY;
    protected static final QName ATT_DEFAULT_VALUE;
    protected static final QName ATT_XPATH;
    protected static final QName ATT_REGEX;
    protected static final QName ATT_SEQUENCE;
    protected static final QName ATT_EXPRN;
    protected static final QName ATT_KEY;
    protected static final QName ATT_SOURCE;
    protected static final QName ATT_TARGET;
    protected static final QName ATT_ONERROR;
    protected static final QName ATT_EVAL;
    protected static final QName ATT_STATS;
    protected static final QName PROP_Q;
    protected static final QName PROPERTY_GROUP_Q;
    protected static final QName FEATURE_Q;
    protected static final QName TARGET_Q;
    protected static final QName DESCRIPTION_Q;

    protected AbstractMediatorFactory() {
        log = LogFactory.getLog(this.getClass());
    }

    @Override
    public final Mediator createMediator(OMElement elem, Properties properties) {
        OMAttribute attDescription;
        Mediator mediator = this.createSpecificMediator(elem, properties);
        OMElement descElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descElem != null) {
            mediator.setDescription(descElem.getText());
        }
        if ((attDescription = elem.getAttribute(ATT_DESCRIPTION)) != null) {
            mediator.setShortDescription(attDescription.getAttributeValue());
        }
        return mediator;
    }

    protected abstract Mediator createSpecificMediator(OMElement var1, Properties var2);

    @Deprecated
    protected void processTraceState(Mediator mediator, OMElement mediatorOmElement) {
        this.processAuditStatus(mediator, mediatorOmElement);
    }

    protected void processAuditStatus(Mediator mediator, OMElement mediatorOmElement) {
        String name = null;
        if (mediator instanceof Nameable) {
            name = ((Nameable)((Object)mediator)).getName();
        }
        if (name == null || "".equals(name)) {
            name = "AnonymousSequence";
        }
        if (mediator instanceof AspectConfigurable) {
            String traceValue;
            OMAttribute trace;
            String statisticsValue;
            AspectConfiguration configuration = new AspectConfiguration(name);
            ((AspectConfigurable)((Object)mediator)).configure(configuration);
            OMAttribute statistics = mediatorOmElement.getAttribute(ATT_STATS);
            if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null && "enable".equals(statisticsValue)) {
                configuration.enableStatistics();
            }
            if ((trace = mediatorOmElement.getAttribute(new QName("", "trace"))) != null && (traceValue = trace.getAttributeValue()) != null && traceValue.equals("enable")) {
                configuration.enableTracing();
            }
        }
    }

    protected Map<String, String> collectNameValuePairs(OMElement elem, QName childElementName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator it = elem.getChildrenWithName(childElementName);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            OMAttribute attName = child.getAttribute(ATT_NAME);
            OMAttribute attValue = child.getAttribute(ATT_VALUE);
            if (attName != null && attValue != null) {
                String name = attName.getAttributeValue().trim();
                String value = attValue.getAttributeValue().trim();
                if (result.containsKey(name)) {
                    this.handleException("Duplicate " + childElementName.getLocalPart() + " with name " + name);
                    continue;
                }
                result.put(name, value);
                continue;
            }
            this.handleException("Both of the name and value attributes are required for a " + childElementName.getLocalPart());
        }
        return result;
    }

    protected void handleException(String message, Exception e) {
        LogFactory.getLog(this.getClass()).error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }

    protected void handleException(String message) {
        LogFactory.getLog(this.getClass()).error((Object)message);
        throw new SynapseException(message);
    }

    protected static void addAllCommentChildrenToList(OMElement el, List<String> commentList) {
        Iterator it = el.getChildren();
        while (it.hasNext()) {
            OMNode child = (OMNode)it.next();
            if (!(child instanceof OMComment) || ((OMComment)child).getValue() == null) continue;
            commentList.add(((OMComment)child).getValue());
        }
    }

    static {
        ATT_NAME = new QName("name");
        ATT_VALUE = new QName("value");
        ATT_DESCRIPTION = new QName("description");
        ATT_IS_MANDATORY = new QName("isMandatory");
        ATT_DEFAULT_VALUE = new QName("defaultValue");
        ATT_XPATH = new QName("xpath");
        ATT_REGEX = new QName("regex");
        ATT_SEQUENCE = new QName("sequence");
        ATT_EXPRN = new QName("expression");
        ATT_KEY = new QName("key");
        ATT_SOURCE = new QName("source");
        ATT_TARGET = new QName("target");
        ATT_ONERROR = new QName("onError");
        ATT_EVAL = new QName("evaluator");
        ATT_STATS = new QName("statistics");
        PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");
        PROPERTY_GROUP_Q = new QName("http://ws.apache.org/ns/synapse", "propertyGroup");
        FEATURE_Q = new QName("http://ws.apache.org/ns/synapse", "feature");
        TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
        DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");
    }
}

