/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractDBMediatorFactory;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public abstract class AbstractDBMediatorSerializer
extends AbstractMediatorSerializer {
    protected void serializeDBInformation(AbstractDBMediator mediator, OMElement dbParent) {
        OMElement connElt = fac.createOMElement("connection", synNS);
        connElt.addChild(this.createPoolElement(mediator));
        dbParent.addChild((OMNode)connElt);
        for (Statement statement : mediator.getStatementList()) {
            dbParent.addChild(this.createStatementElement(statement));
        }
    }

    private OMNode createPoolElement(AbstractDBMediator mediator) {
        String value;
        OMElement poolElt = fac.createOMElement("pool", synNS);
        if (mediator.getDataSourceProps().get(AbstractDBMediatorFactory.DRIVER_Q) != null) {
            if (mediator.isRegistryBasedDriverConfig()) {
                poolElt.addChild((OMNode)this.createElementWithKey(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.DRIVER_Q), AbstractDBMediatorFactory.DRIVER_Q));
            } else {
                poolElt.addChild((OMNode)this.creteElementWithValue(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.DRIVER_Q), AbstractDBMediatorFactory.DRIVER_Q));
            }
            if (mediator.isRegistryBasedUrlConfig()) {
                poolElt.addChild((OMNode)this.createElementWithKey(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.URL_Q), AbstractDBMediatorFactory.URL_Q));
            } else {
                poolElt.addChild((OMNode)this.creteElementWithValue(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.URL_Q), AbstractDBMediatorFactory.URL_Q));
            }
            if (mediator.isRegistryBasedUserConfig()) {
                poolElt.addChild((OMNode)this.createElementWithKey(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.USER_Q), AbstractDBMediatorFactory.USER_Q));
            } else {
                poolElt.addChild((OMNode)this.creteElementWithValue(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.USER_Q), AbstractDBMediatorFactory.USER_Q));
            }
            if (mediator.isRegistryBasedPassConfig()) {
                poolElt.addChild((OMNode)this.createElementWithKey(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.PASS_Q), AbstractDBMediatorFactory.PASS_Q));
            } else {
                poolElt.addChild((OMNode)this.creteElementWithValue(mediator.getDataSourceProps().get(AbstractDBMediatorFactory.PASS_Q), AbstractDBMediatorFactory.PASS_Q));
            }
        } else {
            for (Object o : mediator.getDataSourceProps().keySet()) {
                value = mediator.getDataSourceProps().get(o);
                if (!(o instanceof QName)) continue;
                QName name = (QName)o;
                OMElement elt = fac.createOMElement(name.getLocalPart(), synNS);
                elt.setText(value);
                poolElt.addChild((OMNode)elt);
            }
        }
        for (Object o : mediator.getDataSourceProps().keySet()) {
            value = mediator.getDataSourceProps().get(o);
            if (!(o instanceof String)) continue;
            OMElement elt = fac.createOMElement(AbstractDBMediatorFactory.PROP_Q.getLocalPart(), synNS);
            elt.addAttribute(fac.createOMAttribute("name", nullNS, (String)o));
            elt.addAttribute(fac.createOMAttribute("value", nullNS, value));
            poolElt.addChild((OMNode)elt);
        }
        return poolElt;
    }

    private OMElement creteElementWithValue(String value, QName qName) {
        OMElement elt = fac.createOMElement(qName.getLocalPart(), synNS);
        elt.setText(value);
        return elt;
    }

    private OMElement createElementWithKey(String value, QName qName) {
        OMElement elt = fac.createOMElement(qName.getLocalPart(), synNS);
        elt.addAttribute(fac.createOMAttribute("key", nullNS, value));
        return elt;
    }

    private OMNode createStatementElement(Statement statement) {
        OMElement stmntElt = fac.createOMElement(AbstractDBMediatorFactory.STMNT_Q.getLocalPart(), synNS);
        OMElement sqlElt = fac.createOMElement(AbstractDBMediatorFactory.SQL_Q.getLocalPart(), synNS);
        OMText sqlText = fac.createOMText(statement.getRawStatement(), 12);
        sqlElt.addChild((OMNode)sqlText);
        stmntElt.addChild((OMNode)sqlElt);
        for (Statement.Parameter param : statement.getParameters()) {
            OMElement paramElt = this.createStatementParamElement(param);
            stmntElt.addChild((OMNode)paramElt);
        }
        for (String name : statement.getResultsMap().keySet()) {
            String columnStr = statement.getResultsMap().get(name);
            OMElement resultElt = fac.createOMElement(AbstractDBMediatorFactory.RESULT_Q.getLocalPart(), synNS);
            resultElt.addAttribute(fac.createOMAttribute("name", nullNS, name));
            resultElt.addAttribute(fac.createOMAttribute("column", nullNS, columnStr));
            stmntElt.addChild((OMNode)resultElt);
        }
        return stmntElt;
    }

    private OMElement createStatementParamElement(Statement.Parameter param) {
        OMElement paramElt = fac.createOMElement(AbstractDBMediatorFactory.PARAM_Q.getLocalPart(), synNS);
        if (param.getPropertyName() != null) {
            paramElt.addAttribute(fac.createOMAttribute("value", nullNS, param.getPropertyName()));
        }
        if (param.getPath() != null) {
            SynapsePathSerializer.serializePath(param.getPath(), paramElt, "expression");
        }
        switch (param.getType()) {
            case 1: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "CHAR"));
                break;
            }
            case 12: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "VARCHAR"));
                break;
            }
            case -1: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "LONGVARCHAR"));
                break;
            }
            case 2: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "NUMERIC"));
                break;
            }
            case 3: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DECIMAL"));
                break;
            }
            case -7: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "BIT"));
                break;
            }
            case -6: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TINYINT"));
                break;
            }
            case 5: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "SMALLINT"));
                break;
            }
            case 4: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "INTEGER"));
                break;
            }
            case -5: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "BIGINT"));
                break;
            }
            case 7: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "REAL"));
                break;
            }
            case 6: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "FLOAT"));
                break;
            }
            case 8: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DOUBLE"));
                break;
            }
            case 91: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "DATE"));
                break;
            }
            case 92: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TIME"));
                break;
            }
            case 93: {
                paramElt.addAttribute(fac.createOMAttribute("type", nullNS, "TIMESTAMP"));
                break;
            }
            default: {
                throw new SynapseException("Unknown or unsupported JDBC type : " + param.getType());
            }
        }
        return paramElt;
    }
}

