/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.securevault.secret.SecretInformation;

public abstract class AbstractDBMediatorFactory
extends AbstractMediatorFactory {
    public static final QName URL_Q = new QName("http://ws.apache.org/ns/synapse", "url");
    static final QName DRIVER_Q = new QName("http://ws.apache.org/ns/synapse", "driver");
    static final QName USER_Q = new QName("http://ws.apache.org/ns/synapse", "user");
    static final QName PASS_Q = new QName("http://ws.apache.org/ns/synapse", "password");
    public static final QName DSNAME_Q = new QName("http://ws.apache.org/ns/synapse", "dsName");
    static final QName ICCLASS_Q = new QName("http://ws.apache.org/ns/synapse", "icClass");
    static final QName STMNT_Q = new QName("http://ws.apache.org/ns/synapse", "statement");
    static final QName SQL_Q = new QName("http://ws.apache.org/ns/synapse", "sql");
    static final QName PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    static final QName RESULT_Q = new QName("http://ws.apache.org/ns/synapse", "result");
    static final QName ATT_COLUMN = new QName("column");
    static final QName ATT_TYPE = new QName("type");

    protected void buildDataSource(OMElement elem, AbstractDBMediator mediator) {
        try {
            SynapseXPath xpath = new SynapseXPath("self::node()/syn:connection/syn:pool");
            xpath.addNamespace("syn", "http://ws.apache.org/ns/synapse");
            OMElement pool = (OMElement)xpath.selectSingleNode(elem);
            if (pool != null && pool.getFirstChildWithName(DSNAME_Q) != null) {
                this.readLookupConfig(mediator, pool);
            } else if (pool != null && pool.getFirstChildWithName(DRIVER_Q) != null) {
                this.readCustomDataSourceConfig(pool, mediator);
            } else {
                this.handleException("The DataSource connection information must be specified for using a custom DataSource connection pool or for a JNDI lookup");
            }
        }
        catch (JaxenException e) {
            this.handleException("Error looking up DataSource connection information", (Exception)((Object)e));
        }
    }

    private void readLookupConfig(AbstractDBMediator mediator, OMElement pool) {
        String dataSourceName = this.getValue(pool, DSNAME_Q);
        mediator.setDataSourceName(dataSourceName);
        this.saveElementConfig(pool, DSNAME_Q, mediator);
        if (pool.getFirstChildWithName(ICCLASS_Q) != null) {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", this.getValue(pool, ICCLASS_Q));
            props.put("java.naming.provider.url", this.getValue(pool, URL_Q));
            props.put("java.naming.security.principal", this.getValue(pool, USER_Q));
            props.put("java.naming.security.credentials", this.getValue(pool, PASS_Q));
            mediator.setJndiProperties(props);
            this.saveElementConfig(pool, ICCLASS_Q, mediator);
            this.saveElementConfig(pool, URL_Q, mediator);
            this.saveElementConfig(pool, USER_Q, mediator);
            this.saveElementConfig(pool, PASS_Q, mediator);
        }
    }

    private void readCustomDataSourceConfig(OMElement pool, AbstractDBMediator mediator) {
        DataSourceInformation dataSourceInformation = new DataSourceInformation();
        String driver = this.getKey(pool, DRIVER_Q);
        if (driver != null) {
            mediator.setRegistryBasedDriverConfig(true);
        } else {
            driver = this.getValue(pool, DRIVER_Q);
        }
        driver = ResolverFactory.getInstance().getResolver(driver).resolve();
        dataSourceInformation.setDriver(driver);
        mediator.addDataSourceProperty(DRIVER_Q, driver);
        String url = this.getKey(pool, URL_Q);
        if (url != null) {
            mediator.setRegistryBasedUrlConfig(true);
        } else {
            url = this.getValue(pool, URL_Q);
        }
        url = ResolverFactory.getInstance().getResolver(url).resolve();
        dataSourceInformation.setUrl(url);
        mediator.addDataSourceProperty(URL_Q, url);
        SecretInformation secretInformation = new SecretInformation();
        String user = this.getKey(pool, USER_Q);
        if (user != null) {
            mediator.setRegistryBasedUserConfig(true);
        } else {
            user = this.getValue(pool, USER_Q);
        }
        user = ResolverFactory.getInstance().getResolver(user).resolve();
        secretInformation.setUser(user);
        mediator.addDataSourceProperty(USER_Q, user);
        String password = this.getKey(pool, PASS_Q);
        if (password != null) {
            mediator.setRegistryBasedPassConfig(true);
        } else {
            password = this.getValue(pool, PASS_Q);
        }
        password = ResolverFactory.getInstance().getResolver(password).resolve();
        secretInformation.setAliasSecret(password);
        mediator.addDataSourceProperty(PASS_Q, password);
        dataSourceInformation.setSecretInformation(secretInformation);
        Iterator poolPropIter = pool.getChildrenWithName(PROP_Q);
        while (poolPropIter.hasNext()) {
            OMElement poolProp = (OMElement)poolPropIter.next();
            this.readPoolProperty(mediator, dataSourceInformation, poolProp);
        }
        mediator.setDataSourceInformation(dataSourceInformation);
    }

    private String getKey(OMElement pool, QName qName) {
        OMElement ele = pool.getFirstChildWithName(qName);
        if (ele != null) {
            return ele.getAttributeValue(ATT_KEY);
        }
        this.handleException("Unable to read configuration value for : " + qName);
        return null;
    }

    private void readPoolProperty(AbstractDBMediator mediator, DataSourceInformation dataSourceInformation, OMElement prop) {
        String name = prop.getAttribute(ATT_NAME).getAttributeValue();
        String value = prop.getAttribute(ATT_VALUE).getAttributeValue();
        mediator.addDataSourceProperty(name, value);
        if ("autocommit".equals(name)) {
            if ("true".equals(value)) {
                dataSourceInformation.setDefaultAutoCommit(true);
            } else if ("false".equals(value)) {
                dataSourceInformation.setDefaultAutoCommit(false);
            }
        } else if ("isolation".equals(name)) {
            try {
                if ("Connection.TRANSACTION_NONE".equals(value)) {
                    dataSourceInformation.setDefaultTransactionIsolation(0);
                } else if ("Connection.TRANSACTION_READ_COMMITTED".equals(value)) {
                    dataSourceInformation.setDefaultTransactionIsolation(2);
                } else if ("Connection.TRANSACTION_READ_UNCOMMITTED".equals(value)) {
                    dataSourceInformation.setDefaultTransactionIsolation(1);
                } else if ("Connection.TRANSACTION_REPEATABLE_READ".equals(value)) {
                    dataSourceInformation.setDefaultTransactionIsolation(4);
                } else if ("Connection.TRANSACTION_SERIALIZABLE".equals(value)) {
                    dataSourceInformation.setDefaultTransactionIsolation(8);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("initialsize".equals(name)) {
            try {
                dataSourceInformation.setInitialSize(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("maxactive".equals(name)) {
            try {
                dataSourceInformation.setMaxActive(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("maxidle".equals(name)) {
            try {
                dataSourceInformation.setMaxIdle(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("maxopenstatements".equals(name)) {
            try {
                dataSourceInformation.setMaxOpenPreparedStatements(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("maxwait".equals(name)) {
            try {
                dataSourceInformation.setMaxWait(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("minidle".equals(name)) {
            try {
                dataSourceInformation.setMinIdle(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("poolstatements".equals(name)) {
            if ("true".equals(value)) {
                dataSourceInformation.setPoolPreparedStatements(true);
            } else if ("false".equals(value)) {
                dataSourceInformation.setPoolPreparedStatements(false);
            }
        } else if ("testonborrow".equals(name)) {
            if ("true".equals(value)) {
                dataSourceInformation.setTestOnBorrow(true);
            } else if ("false".equals(value)) {
                dataSourceInformation.setTestOnBorrow(false);
            }
        } else if ("testonreturn".equals(name)) {
            if ("true".equals(value)) {
                dataSourceInformation.setTestOnReturn(true);
            } else if ("false".equals(value)) {
                dataSourceInformation.setTestOnReturn(false);
            }
        } else if ("testwhileidle".equals(name)) {
            if ("true".equals(value)) {
                dataSourceInformation.setTestWhileIdle(true);
            } else if ("false".equals(value)) {
                dataSourceInformation.setTestWhileIdle(false);
            }
        } else if ("validationquery".equals(name)) {
            dataSourceInformation.setValidationQuery(value);
        }
    }

    protected void processStatements(OMElement elem, AbstractDBMediator mediator) {
        Iterator iter = elem.getChildrenWithName(STMNT_Q);
        while (iter.hasNext()) {
            OMElement stmntElt = (OMElement)iter.next();
            Statement statement = new Statement(this.getValue(stmntElt, SQL_Q));
            Iterator paramIter = stmntElt.getChildrenWithName(PARAM_Q);
            while (paramIter.hasNext()) {
                OMElement paramElt = (OMElement)paramIter.next();
                String strPath = this.getAttribute(paramElt, ATT_EXPRN);
                String value = this.getAttribute(paramElt, ATT_VALUE);
                if (strPath == null && value == null) continue;
                SynapsePath path = null;
                if (strPath != null) {
                    try {
                        path = SynapsePathFactory.getSynapsePath(paramElt, ATT_EXPRN);
                    }
                    catch (JaxenException e) {
                        this.handleException("Invalid XPath/JsonPath specified for the source attribute : " + strPath);
                    }
                }
                statement.addParameter(value, path, this.getAttribute(paramElt, ATT_TYPE));
            }
            Iterator resultIter = stmntElt.getChildrenWithName(RESULT_Q);
            while (resultIter.hasNext()) {
                OMElement resultElt = (OMElement)resultIter.next();
                if (this.getAttribute(resultElt, ATT_NAME) == null || this.getAttribute(resultElt, ATT_COLUMN) == null) {
                    this.handleException("Invalid result element found missing either name and column [DBLookup] mediator");
                }
                statement.addResult(this.getAttribute(resultElt, ATT_NAME), this.getAttribute(resultElt, ATT_COLUMN));
            }
            mediator.addStatement(statement);
        }
    }

    protected String getValue(OMElement elt, QName qName) {
        OMElement e = elt.getFirstChildWithName(qName);
        if (e != null) {
            return e.getText();
        }
        this.handleException("Unable to read configuration value for : " + qName);
        return null;
    }

    protected String getAttribute(OMElement elt, QName qName) {
        OMAttribute a = elt.getAttribute(qName);
        if (a != null) {
            return a.getAttributeValue();
        }
        return null;
    }

    private void saveElementConfig(OMElement element, QName qname, AbstractDBMediator mediator) {
        mediator.addDataSourceProperty(qname, this.getValue(element, qname));
    }
}

