/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public class SynapsePropertiesLoader {
    private static Log log = LogFactory.getLog(SynapsePropertiesLoader.class);
    private static final Properties cacheProperties = new Properties();
    private static boolean reload = true;

    private SynapsePropertiesLoader() {
    }

    public static Properties loadSynapseProperties() {
        if (reload) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading synapse properties from a property file");
            }
            cacheProperties.putAll((Map<?, ?>)MiscellaneousUtil.loadProperties((String)"synapse.properties"));
            reload = false;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving synapse properties from the cache");
        }
        Properties tempProperties = new Properties();
        tempProperties.putAll((Map<?, ?>)cacheProperties);
        return tempProperties;
    }

    public static Properties reloadSynapseProperties() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reloading synapse properties");
        }
        reload = true;
        cacheProperties.clear();
        return SynapsePropertiesLoader.loadSynapseProperties();
    }

    public static String getPropertyValue(String key, String defaultValue) {
        return MiscellaneousUtil.getProperty((Properties)SynapsePropertiesLoader.loadSynapseProperties(), (String)key, (String)defaultValue);
    }

    public static Boolean getBooleanProperty(String name, Boolean def) {
        String val = MiscellaneousUtil.getProperty((Properties)SynapsePropertiesLoader.loadSynapseProperties(), (String)name, (String)String.valueOf(def));
        if (val == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter : " + name + " is not defined in the synapse.properties file."));
            }
            return def;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("synapse.properties parameter : " + name + " = " + val));
        }
        return Boolean.valueOf(val);
    }
}

