/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.commons.util.PropertyHelper;

public class SynapseHandlersLoader {
    private static final QName ROOT_Q = new QName("handlers");
    private static final QName HANDLER_Q = new QName("handler");
    private static final QName CLASS_Q = new QName("class");
    private static final QName NAME_ATT = new QName("name");
    private static final QName PARAM_Q = new QName("parameter");
    private static final QName VALUE_ATT = new QName("value");
    private static Log log = LogFactory.getLog(SynapseHandlersLoader.class);

    public static List<SynapseHandler> loadHandlers() {
        ArrayList<SynapseHandler> handlers = new ArrayList<SynapseHandler>();
        OMElement handlersConfig = MiscellaneousUtil.loadXMLConfig((String)"synapse-handlers.xml");
        if (handlersConfig != null) {
            if (!ROOT_Q.equals(handlersConfig.getQName())) {
                SynapseHandlersLoader.handleException("Invalid handler configuration file");
            }
            Iterator iterator = handlersConfig.getChildrenWithName(HANDLER_Q);
            while (iterator.hasNext()) {
                OMElement handlerElem = (OMElement)iterator.next();
                String name = null;
                if (handlerElem.getAttribute(NAME_ATT) != null) {
                    name = handlerElem.getAttributeValue(NAME_ATT);
                } else {
                    SynapseHandlersLoader.handleException("Name not defined in one or more handlers");
                }
                if (handlerElem.getAttribute(CLASS_Q) != null) {
                    String className = handlerElem.getAttributeValue(CLASS_Q);
                    if (!"".equals(className)) {
                        SynapseHandler handler = SynapseHandlersLoader.createHandler(className);
                        if (handler == null) continue;
                        handlers.add(handler);
                        handler.setName(name);
                        SynapseHandlersLoader.populateParameters(handlerElem, handler);
                        continue;
                    }
                    SynapseHandlersLoader.handleException("Class name is null for handle name : " + name);
                    continue;
                }
                SynapseHandlersLoader.handleException("Class name not defined for handler named : " + name);
            }
        }
        return handlers;
    }

    private static SynapseHandler createHandler(String classFQName) {
        Object obj = null;
        try {
            obj = Class.forName(classFQName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            SynapseHandlersLoader.handleException("Error creating Handler for class name : " + classFQName, e);
        }
        if (obj instanceof SynapseHandler) {
            return obj;
        }
        SynapseHandlersLoader.handleException("Error creating Handler. The Handler should be of type org.apache.synapse.Handler");
        return null;
    }

    private static void populateParameters(OMElement handlerElem, SynapseHandler handler) {
        Iterator it = handlerElem.getChildrenWithName(PARAM_Q);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            String propName = child.getAttribute(NAME_ATT).getAttributeValue();
            if (propName == null) {
                SynapseHandlersLoader.handleException("Synapse Handler parameter must contain the name attribute");
                continue;
            }
            if (child.getAttribute(VALUE_ATT) != null) {
                String value = child.getAttribute(VALUE_ATT).getAttributeValue();
                handler.addProperty(propName, value);
                PropertyHelper.setInstanceProperty((String)propName, (Object)value, (Object)handler);
                continue;
            }
            OMElement omElt = child.getFirstElement();
            if (omElt != null) {
                handler.addProperty(propName, omElt);
                PropertyHelper.setInstanceProperty((String)propName, (Object)omElt, (Object)handler);
                continue;
            }
            SynapseHandlersLoader.handleException("Synapse Handler parameter must contain name and value attributes, or a name and a child XML fragment");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
        throw new SynapseException(msg, ex);
    }
}

