/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationBuilder;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.LogMediator;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.apache.synapse.mediators.filters.InMediator;
import org.apache.synapse.mediators.filters.OutMediator;
import org.apache.synapse.registry.Registry;

public class SynapseConfigurationBuilder {
    private static Log log = LogFactory.getLog(SynapseConfigurationBuilder.class);

    public static SynapseConfiguration getDefaultConfiguration() {
        SynapseConfiguration config = SynapseConfigUtils.newConfiguration();
        SequenceMediator mainMediator = new SequenceMediator();
        InMediator inMediator = new InMediator();
        inMediator.addChild(new LogMediator());
        mainMediator.addChild(inMediator);
        OutMediator outMediator = new OutMediator();
        outMediator.addChild(new SendMediator());
        mainMediator.addChild(outMediator);
        mainMediator.setName("main");
        config.addSequence("main", mainMediator);
        SequenceMediator faultMediator = new SequenceMediator();
        LogMediator fault = new LogMediator();
        fault.setLogLevel(3);
        faultMediator.addChild(fault);
        faultMediator.setName("fault");
        config.addSequence("fault", faultMediator);
        config.setDescription("The default configuration of the ESB, that is created programatically at the startup");
        return config;
    }

    public static SynapseConfiguration getConfiguration(String configFile, Properties properties) {
        File synapseConfigLocation = new File(configFile);
        if (!synapseConfigLocation.exists()) {
            String message = "Unable to load the Synapse configuration from : " + configFile + ". Specified file not found";
            log.fatal((Object)message);
            throw new SynapseException(message);
        }
        SynapseConfiguration synCfg = null;
        if (synapseConfigLocation.isFile()) {
            try {
                synCfg = XMLConfigurationBuilder.getConfiguration(new FileInputStream(configFile), properties);
                log.info((Object)("Loaded Synapse configuration from : " + configFile));
            }
            catch (Exception e) {
                SynapseConfigurationBuilder.handleException("Could not initialize Synapse : " + e.getMessage(), e);
            }
        } else if (synapseConfigLocation.isDirectory()) {
            synCfg = MultiXMLConfigurationBuilder.getConfiguration(configFile, properties);
            log.info((Object)("Loaded Synapse configuration from the artifact repository at : " + configFile));
        }
        assert (synCfg != null);
        synCfg.setPathToConfigFile(new File(configFile).getAbsolutePath());
        Registry localConfigReg = synCfg.getRegistry();
        if (synCfg.getLocalRegistry().isEmpty() && synCfg.getProxyServices().isEmpty() && localConfigReg != null) {
            OMNode remoteConfigNode;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Only the registry is defined in the synapse configuration, trying to fetch a configuration from the registry");
            }
            if ((remoteConfigNode = localConfigReg.lookup("synapse.xml")) != null) {
                try {
                    synCfg = XMLConfigurationBuilder.getConfiguration(SynapseConfigUtils.getStreamSource(remoteConfigNode).getInputStream(), properties);
                    if (synCfg.getRegistry() == null) {
                        synCfg.setRegistry(localConfigReg);
                    }
                    log.warn((Object)"Registry declaration has been overwritten by the registry declaration found at the remote configuration");
                }
                catch (XMLStreamException xse) {
                    throw new SynapseException("Problem loading remote synapse.xml ", xse);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find a synapse configuration on the registry");
            }
        }
        if (synCfg.getMainSequence() == null) {
            SynapseConfigUtils.setDefaultMainSequence(synCfg);
        }
        if (synCfg.getFaultSequence() == null) {
            SynapseConfigUtils.setDefaultFaultSequence(synCfg);
        }
        return synCfg;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

