/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.api.inbound.InboundApiUtils;
import org.apache.synapse.aspects.flow.statistics.store.CompletedStructureStore;
import org.apache.synapse.carbonext.TenantInfoConfigProvider;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.commons.datasource.DataSourceRepositoryHolder;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.util.ext.TenantInfoInitiator;
import org.apache.synapse.commons.util.ext.TenantInfoInitiatorProvider;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseObserver;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.TemplateMediatorFactory;
import org.apache.synapse.config.xml.XMLToTemplateMapper;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.config.xml.endpoints.XMLToEndpointMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.processor.impl.AbstractMessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskManager;

public class SynapseConfiguration
implements ManagedLifecycle,
SynapseArtifact {
    private static final Log log = LogFactory.getLog(SynapseConfiguration.class);
    private static final String ENTRY = "entry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private static final String TEMPLATE = "sequence-template";
    private Registry registry = null;
    private TaskManager taskManager = null;
    private QName defaultQName = null;
    private Mediator mandatorySequence = null;
    private final Map<String, ProxyService> proxyServices = new ConcurrentHashMap<String, ProxyService>();
    private final Map<String, Startup> startups = new ConcurrentHashMap<String, Startup>();
    private final Map<String, Object> localRegistry = new ConcurrentHashMap<String, Object>();
    private Properties properties = new Properties();
    private Timer synapseTimer = new Timer(true);
    private AxisConfiguration axisConfiguration = new AxisConfiguration();
    private String pathToConfigFile = null;
    private Map<String, SynapseEventSource> eventSources = new ConcurrentHashMap<String, SynapseEventSource>();
    private List<SynapseObserver> observers = new ArrayList<SynapseObserver>();
    private List<SynapseObserver> removableObservers = new ArrayList<SynapseObserver>(1);
    private Map<String, PriorityExecutor> executors = new ConcurrentHashMap<String, PriorityExecutor>();
    private Map<String, MessageStore> messageStores = new ConcurrentHashMap<String, MessageStore>();
    private Map<String, MessageProcessor> messageProcessors = new ConcurrentHashMap<String, MessageProcessor>();
    private Map<String, Template> endpointTemplates = new ConcurrentHashMap<String, Template>();
    private Map<String, API> apiTable = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, String> swaggerTable = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, InboundEndpoint> inboundEndpointMap = new ConcurrentHashMap<String, InboundEndpoint>();
    private Map<String, Map<String, API>> apiTableWithBindsTo = Collections.synchronizedMap(new LinkedHashMap());
    private String description = null;
    private SynapseArtifactDeploymentStore artifactDeploymentStore = new SynapseArtifactDeploymentStore();
    Map<String, Library> synapseLibraries = new ConcurrentHashMap<String, Library>();
    Map<String, SynapseImport> synapseImports = new ConcurrentHashMap<String, SynapseImport>();
    private Map<String, Object> decryptedCacheMap = new ConcurrentHashMap<String, Object>();
    private boolean allowHotUpdate = true;
    private List<String> commentedTextList = new ArrayList<String>();
    private CompletedStructureStore completedStructureStore = new CompletedStructureStore();

    public synchronized void addSequence(String key, Mediator mediator) {
        this.assertAlreadyExists(key, SEQUENCE);
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceAdded(mediator);
        }
    }

    public synchronized void addSequenceTemplate(String key, TemplateMediator mediator) {
        this.assertAlreadyExists(key, TEMPLATE);
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceTemplateAdded(mediator);
        }
    }

    public synchronized void updateSequenceTemplate(String key, TemplateMediator mediator) {
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceTemplateAdded(mediator);
        }
    }

    public synchronized void updateSequence(String key, Mediator mediator) {
        this.localRegistry.put(key, mediator);
        for (SynapseObserver o : this.observers) {
            o.sequenceAdded(mediator);
        }
    }

    public void addSequence(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SequenceMediator> getDefinedSequences() {
        HashMap<String, SequenceMediator> definedSequences = new HashMap<String, SequenceMediator>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                SequenceMediator seq;
                if (!(o instanceof SequenceMediator) || (seq = (SequenceMediator)o).getName().startsWith("_Hidden_Sequence_")) continue;
                definedSequences.put(seq.getName(), seq);
            }
        }
        return definedSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TemplateMediator> getSequenceTemplates() {
        HashMap<String, TemplateMediator> definedTemplates = new HashMap<String, TemplateMediator>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof TemplateMediator)) continue;
                TemplateMediator template = (TemplateMediator)o;
                definedTemplates.put(template.getName(), template);
            }
        }
        return definedTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Template> getEndpointTemplates() {
        HashMap<String, Template> definedTemplates = new HashMap<String, Template>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Template)) continue;
                Template template = (Template)o;
                definedTemplates.put(template.getName(), template);
            }
        }
        return definedTemplates;
    }

    public void addInboundEndpoint(String name, InboundEndpoint inboundEndpoint) {
        if (!this.inboundEndpointMap.containsKey(name)) {
            this.inboundEndpointMap.put(name, inboundEndpoint);
            for (SynapseObserver o : this.observers) {
                o.inboundEndpointAdded(inboundEndpoint);
            }
        } else {
            this.handleException("Duplicate inbound  endpoint definition by the name: " + name);
        }
    }

    public InboundEndpoint getInboundEndpoint(String name) {
        return this.inboundEndpointMap.get(name);
    }

    public Collection<InboundEndpoint> getInboundEndpoints() {
        return Collections.unmodifiableCollection(this.inboundEndpointMap.values());
    }

    public void updateInboundEndpoint(String name, InboundEndpoint inboundEndpoint) {
        if (!this.inboundEndpointMap.containsKey(name)) {
            this.handleException("No Inbound Endpoint exists by the name: " + name);
        } else {
            this.inboundEndpointMap.put(name, inboundEndpoint);
            for (SynapseObserver o : this.observers) {
                o.inboundEndpointUpdated(inboundEndpoint);
            }
        }
    }

    public void removeInboundEndpoint(String name) {
        InboundEndpoint inboundEndpoint = this.inboundEndpointMap.get(name);
        if (inboundEndpoint != null) {
            this.inboundEndpointMap.remove(name);
            for (SynapseObserver o : this.observers) {
                o.inboundEndpointRemoved(inboundEndpoint);
            }
        } else {
            this.handleException("No Inbound Endpoint exists by the name: " + name);
        }
    }

    public synchronized void addAPI(String name, API api) {
        this.addAPI(name, api, true);
    }

    public synchronized void addAPI(String name, API api, boolean reOrder) {
        if (!this.apiTable.containsKey(name)) {
            for (API existingAPI : this.apiTable.values()) {
                if (!api.getVersion().equals(existingAPI.getVersion()) || !existingAPI.getContext().equals(api.getContext())) continue;
                this.handleException("URL context: " + api.getContext() + " is already registered with the API: " + existingAPI.getName());
            }
            this.apiTable.put(name, api);
            this.addBindsToMappings(name, api);
            if (reOrder) {
                this.reconstructAPITable();
            }
            for (SynapseObserver o : this.observers) {
                o.apiAdded(api);
            }
        } else {
            this.handleException("Duplicate resource definition by the name: " + name);
        }
    }

    private void addBindsToMappings(String name, API api) {
        InboundApiUtils.populateBindsTo(api);
        for (String inboundEndpointName : api.getBindsTo()) {
            if (this.apiTableWithBindsTo.containsKey(inboundEndpointName)) {
                this.apiTableWithBindsTo.get(inboundEndpointName).put(name, api);
                continue;
            }
            Map<String, API> apis = Collections.synchronizedMap(new LinkedHashMap());
            apis.put(name, api);
            this.apiTableWithBindsTo.put(inboundEndpointName, apis);
        }
    }

    public synchronized void addSwaggerDefinition(String apiName, String swaggerDefinition) {
        if (!this.swaggerTable.containsKey(apiName)) {
            this.swaggerTable.put(apiName, swaggerDefinition);
        } else {
            this.handleException("Duplicate swagger definition by the name: " + apiName);
        }
    }

    public synchronized void validateSwaggerTable() {
        for (String name : this.swaggerTable.keySet()) {
            if (this.apiTable.containsKey(name)) continue;
            this.swaggerTable.remove(name);
        }
    }

    public String getSwaggerOfTheAPI(String apiName) {
        return this.swaggerTable.get(apiName);
    }

    public synchronized void updateAPI(String name, API api) {
        if (!this.apiTable.containsKey(name)) {
            this.handleException("No API exists by the name: " + name);
        } else {
            for (API existingAPI : this.apiTable.values()) {
                if (api.getName().equals(existingAPI.getName()) || !api.getVersion().equals(existingAPI.getVersion()) || !existingAPI.getContext().equals(api.getContext())) continue;
                this.handleException("URL context: " + api.getContext() + " is already registered with the API: " + existingAPI.getName());
            }
            this.apiTable.put(name, api);
            this.removeBindsToMappings(name);
            this.addBindsToMappings(name, api);
            this.reconstructAPITable();
            for (SynapseObserver o : this.observers) {
                o.apiUpdated(api);
            }
        }
    }

    public synchronized Collection<API> getAPIs() {
        return Collections.unmodifiableCollection(this.apiTable.values());
    }

    public synchronized Collection<API> getAPIs(String bindTo) {
        Map<String, API> apis = this.apiTableWithBindsTo.get(bindTo);
        return apis != null ? apis.values() : Collections.emptyList();
    }

    public synchronized API getAPI(String name) {
        return this.apiTable.get(name);
    }

    public synchronized void removeAPI(String name) {
        API api = this.apiTable.get(name);
        if (api != null) {
            this.apiTable.remove(name);
            this.removeBindsToMappings(name);
            for (SynapseObserver o : this.observers) {
                o.apiRemoved(api);
            }
        } else {
            this.handleException("No API exists by the name: " + name);
        }
    }

    private void removeBindsToMappings(String apiName) {
        Iterator<Map.Entry<String, Map<String, API>>> iterator = this.apiTableWithBindsTo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, API>> mappings = iterator.next();
            Map<String, API> apis = mappings.getValue();
            apis.remove(apiName);
            if (!apis.isEmpty()) continue;
            iterator.remove();
        }
    }

    public synchronized void removeSwaggerFromTheAPI(String name) {
        if (this.swaggerTable.containsKey(name)) {
            this.swaggerTable.remove(name);
        }
    }

    public TemplateMediator getSequenceTemplate(String key) {
        TemplateMediator templateFromLib;
        Object o = this.getEntry(key);
        if (o instanceof TemplateMediator) {
            return (TemplateMediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(new XMLToTemplateMapper(this));
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                TemplateMediator m;
                try {
                    o = this.registry.getResource(entry, this.getProperties());
                }
                catch (SynapseException synEx) {
                    o = null;
                    log.warn((Object)("Encountered an error while retrieving resources from registry : " + synEx.getMessage() + "\nTherefore fetching template from registry will be skipped."));
                }
                if (o != null && o instanceof TemplateMediator) {
                    this.localRegistry.put(key, entry);
                    return (TemplateMediator)o;
                }
                if (o instanceof OMNode && (m = (TemplateMediator)new TemplateMediatorFactory().createMediator((OMElement)o, this.properties)) != null) {
                    entry.setValue(m);
                    return m;
                }
            }
        } else {
            Object value = entry.getValue();
            if (value instanceof OMNode) {
                this.properties.put("SynapseConfiguration", this);
                Object object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties());
                if (object instanceof TemplateMediator) {
                    entry.setValue(object);
                    return (TemplateMediator)object;
                }
            }
        }
        if ((templateFromLib = LibDeployerUtils.getLibArtifact(this.synapseLibraries, key, TemplateMediator.class)) != null) {
            return templateFromLib;
        }
        return null;
    }

    public Mediator getMandatorySequence() {
        return this.mandatorySequence;
    }

    public void setMandatorySequence(Mediator mandatorySequence) {
        this.mandatorySequence = mandatorySequence;
    }

    public Mediator getSequence(String key) {
        Object o = this.getEntry(key);
        if (o instanceof Mediator) {
            return (Mediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Mediator) {
                    this.localRegistry.put(key, entry);
                    return (Mediator)o;
                }
                if (o instanceof OMNode) {
                    this.properties.put("SynapseConfiguration", this);
                    Mediator m = (Mediator)MediatorFactoryFinder.getInstance().getObjectFromOMNode((OMNode)o, this.properties);
                    if (m != null) {
                        entry.setValue(m);
                        return m;
                    }
                }
            }
        } else {
            Object value = entry.getValue();
            if (value instanceof OMNode) {
                this.properties.put("SynapseConfiguration", this);
                Object object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties());
                if (object instanceof Mediator) {
                    entry.setValue(object);
                    return (Mediator)object;
                }
            }
        }
        return null;
    }

    public OMElement getFormat(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof OMElement) {
            return (OMElement)o;
        }
        Entry entry = new Entry(key);
        entry.setType(3);
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (this.registry != null && (o = this.registry.getFormat(entry)) instanceof OMElement) {
            this.localRegistry.put(key, o);
            return (OMElement)o;
        }
        return null;
    }

    public synchronized void removeSequence(String key) {
        Object sequence = this.localRegistry.get(key);
        if (sequence instanceof Mediator) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.sequenceRemoved((Mediator)sequence);
            }
        } else {
            this.handleException("No sequence exists by the key/name : " + key);
        }
    }

    public synchronized void removeSequenceTemplate(String name) {
        Object sequence = this.localRegistry.get(name);
        if (sequence instanceof TemplateMediator) {
            this.localRegistry.remove(name);
            for (SynapseObserver o : this.observers) {
                o.sequenceTemplateRemoved((Mediator)sequence);
            }
        } else {
            this.handleException("No template exists by the key/name : " + name);
        }
    }

    public Mediator getMainSequence() {
        return this.getSequence("main");
    }

    public Mediator getFaultSequence() {
        return this.getSequence("fault");
    }

    public synchronized void addEntry(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        if (entry.getType() == 2 && entry.getValue() == null) {
            try {
                SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(this.axisConfiguration);
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString(), synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : ""));
                this.localRegistry.put(key, entry);
                for (SynapseObserver o : this.observers) {
                    o.entryAdded(entry);
                }
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
            for (SynapseObserver o : this.observers) {
                o.entryAdded(entry);
            }
        }
    }

    public synchronized void updateEntry(String key, Entry entry) {
        if (entry.getType() == 2 && entry.getValue() == null) {
            try {
                SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(this.axisConfiguration);
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString(), synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : ""));
                this.localRegistry.put(key, entry);
                for (SynapseObserver o : this.observers) {
                    o.entryAdded(entry);
                }
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
            for (SynapseObserver o : this.observers) {
                o.entryAdded(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getCachedEntries() {
        HashMap<String, Entry> cachedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                Entry entry;
                if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
                cachedEntries.put(entry.getKey(), entry);
            }
        }
        return cachedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Entry> getDefinedEntries() {
        HashMap<String, Entry> definedEntries = new HashMap<String, Entry>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Entry) || ((Entry)o).getType() == 3) continue;
                Entry entry = (Entry)o;
                definedEntries.put(entry.getKey(), entry);
            }
        }
        return definedEntries;
    }

    public Object getLocalRegistryEntry(String key) {
        Entry entry;
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Entry && !(entry = (Entry)o).isDynamic()) {
            return entry.getValue();
        }
        return null;
    }

    public Object getEntry(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Entry) {
            Entry entry = (Entry)o;
            if (!entry.isDynamic() || entry.isCached() && !entry.isExpired()) {
                return entry.getValue();
            }
            if (this.registry != null) {
                if (entry.isCached()) {
                    try {
                        o = this.registry.getResource(entry, this.getProperties());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error while loading the resource " + key + " from the remote registry. Previously cached value will be used. Check the registry accessibility."));
                        return entry.getValue();
                    }
                } else {
                    o = this.registry.getResource(entry, this.getProperties());
                }
            } else {
                if (entry.isCached()) {
                    log.warn((Object)("The registry is no longer available in the Synapse configuration. Using the previously cached value for the resource : " + key));
                    return entry.getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will not  evaluate the value of the remote entry with a key " + key + ",  because the registry is not available"));
                }
                return null;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntryDefinition(String key) {
        Object o = this.localRegistry.get(key);
        if (o == null || o instanceof Entry) {
            if (o == null) {
                SynapseConfiguration synapseConfiguration = this;
                synchronized (synapseConfiguration) {
                    o = this.localRegistry.get(key);
                    if (o == null) {
                        Entry entry = new Entry(key);
                        entry.setType(3);
                        this.addEntry(key, entry);
                        return entry;
                    }
                }
            }
            return (Entry)o;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no local registry entry for key : " + key));
        }
        return null;
    }

    public synchronized void removeEntry(String key) {
        Object entry = this.localRegistry.get(key);
        if (entry instanceof Entry) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.entryRemoved((Entry)entry);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No entry exists by the key : " + key));
        }
    }

    public void clearCachedEntry(String key) {
        Entry entry = this.getEntryDefinition(key);
        if (entry != null && entry.isDynamic() && entry.isCached()) {
            entry.clearCache();
        }
    }

    public synchronized void clearCache() {
        for (Object o : this.localRegistry.values()) {
            Entry entry;
            if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
            entry.clearCache();
        }
    }

    public synchronized void addEndpoint(String key, Endpoint endpoint) {
        this.assertAlreadyExists(key, ENDPOINT);
        this.localRegistry.put(key, endpoint);
        for (SynapseObserver o : this.observers) {
            o.endpointAdded(endpoint);
        }
    }

    public synchronized void updateEndpoint(String key, Endpoint endpoint) {
        this.localRegistry.put(key, endpoint);
        for (SynapseObserver o : this.observers) {
            o.endpointAdded(endpoint);
        }
    }

    public void addEndpoint(String key, Entry entry) {
        this.assertAlreadyExists(key, ENTRY);
        this.localRegistry.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Endpoint> getDefinedEndpoints() {
        HashMap<String, Endpoint> definedEndpoints = new HashMap<String, Endpoint>();
        SynapseConfiguration synapseConfiguration = this;
        synchronized (synapseConfiguration) {
            for (Object o : this.localRegistry.values()) {
                if (!(o instanceof Endpoint)) continue;
                Endpoint ep = (Endpoint)o;
                definedEndpoints.put(ep.getName(), ep);
            }
        }
        return definedEndpoints;
    }

    public Endpoint getEndpoint(String key) {
        Object o = this.getEntry(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(XMLToEndpointMapper.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Endpoint) {
                    this.localRegistry.put(key, entry);
                    return (Endpoint)o;
                }
                if (o instanceof OMNode) {
                    this.properties.put("SynapseConfiguration", this);
                    Endpoint e = (Endpoint)XMLToEndpointMapper.getInstance().getObjectFromOMNode((OMNode)o, this.properties);
                    if (e != null) {
                        entry.setValue(e);
                        return e;
                    }
                }
            }
        } else {
            Object value = entry.getValue();
            if (value instanceof OMNode) {
                this.properties.put("SynapseConfiguration", this);
                Object object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties());
                if (object instanceof Endpoint) {
                    entry.setValue(object);
                    return (Endpoint)object;
                }
            }
        }
        return null;
    }

    public synchronized void removeEndpoint(String key) {
        Object endpoint = this.localRegistry.get(key);
        if (endpoint instanceof Endpoint) {
            this.localRegistry.remove(key);
            for (SynapseObserver o : this.observers) {
                o.endpointRemoved((Endpoint)endpoint);
            }
        } else {
            this.handleException("No endpoint exists by the key/name : " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyService(String name, ProxyService proxy) {
        AxisConfiguration axisConfiguration = this.axisConfiguration;
        synchronized (axisConfiguration) {
            if (!this.proxyServices.containsKey(name)) {
                this.proxyServices.put(name, proxy);
                for (SynapseObserver o : this.observers) {
                    o.proxyServiceAdded(proxy);
                }
            } else {
                this.handleException("Duplicate proxy service by the name : " + name);
            }
        }
    }

    public ProxyService getProxyService(String name) {
        return this.proxyServices.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyService(String name) {
        AxisConfiguration axisConfiguration = this.axisConfiguration;
        synchronized (axisConfiguration) {
            ProxyService proxy = this.proxyServices.get(name);
            if (proxy == null) {
                this.handleException("Unknown proxy service for name : " + name);
            } else {
                try {
                    if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                        if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                            this.getAxisConfiguration().getService(name).setActive(false);
                        }
                        this.getAxisConfiguration().removeService(name);
                    }
                    this.proxyServices.remove(name);
                    for (SynapseObserver o : this.observers) {
                        o.proxyServiceRemoved(proxy);
                    }
                }
                catch (AxisFault axisFault) {
                    this.handleException(axisFault.getMessage());
                }
            }
        }
    }

    public Collection<ProxyService> getProxyServices() {
        return Collections.unmodifiableCollection(this.proxyServices.values());
    }

    public Map getLocalRegistry() {
        return this.localRegistry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setAxisConfiguration(AxisConfiguration axisConfig) {
        this.axisConfiguration = axisConfig;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public String getPathToConfigFile() {
        return this.pathToConfigFile;
    }

    public void setPathToConfigFile(String pathToConfigFile) {
        this.pathToConfigFile = pathToConfigFile;
    }

    public void setDefaultQName(QName defaultQName) {
        this.defaultQName = defaultQName;
    }

    public QName getDefaultQName() {
        return this.defaultQName;
    }

    public Timer getSynapseTimer() {
        return this.synapseTimer;
    }

    public void setSynapseTimer(Timer synapseTimer) {
        this.synapseTimer = synapseTimer;
    }

    public Collection<Startup> getStartups() {
        return this.startups.values();
    }

    public Startup getStartup(String id) {
        return this.startups.get(id);
    }

    public synchronized void addStartup(Startup startup) {
        if (!this.startups.containsKey(startup.getName())) {
            this.startups.put(startup.getName(), startup);
            for (SynapseObserver o : this.observers) {
                o.startupAdded(startup);
            }
        } else {
            this.handleException("Duplicate startup by the name : " + startup.getName());
        }
    }

    public synchronized void updateStartup(Startup startup) {
        this.startups.put(startup.getName(), startup);
        for (SynapseObserver o : this.observers) {
            o.startupAdded(startup);
        }
    }

    public synchronized void removeStartup(String name) {
        Startup startup = this.startups.get(name);
        if (startup != null) {
            this.startups.remove(name);
            for (SynapseObserver o : this.observers) {
                o.startupRemoved(startup);
            }
        } else {
            this.handleException("No startup exists by the name : " + name);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String propKey, String def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return def;
    }

    public long getProperty(String propKey, long def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return Long.valueOf(val);
        }
        return def;
    }

    public String getProperty(String propKey) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return null;
    }

    @Override
    public synchronized void destroy() {
        this.destroy(false);
    }

    public synchronized void destroy(boolean preserverState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying the Synapse Configuration");
        }
        this.synapseTimer.cancel();
        this.synapseTimer = null;
        for (ProxyService proxyService : this.getProxyServices()) {
            if (proxyService.getTargetInLineInSequence() != null) {
                proxyService.getTargetInLineInSequence().destroy();
            }
            if (proxyService.getTargetInLineOutSequence() == null) continue;
            proxyService.getTargetInLineOutSequence().destroy();
        }
        for (ManagedLifecycle managedLifecycle : this.getDefinedSequences().values()) {
            managedLifecycle.destroy();
        }
        for (TemplateMediator templateMediator : this.getSequenceTemplates().values()) {
            templateMediator.destroy();
        }
        for (InboundEndpoint inboundEndpoint : this.getInboundEndpoints()) {
            inboundEndpoint.destroy(false);
        }
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            endpoint.destroy();
        }
        for (ManagedLifecycle managedLifecycle : this.startups.values()) {
            if (managedLifecycle instanceof StartUpController) {
                ((StartUpController)managedLifecycle).destroy(false);
                continue;
            }
            managedLifecycle.destroy();
        }
        try {
            SALSessions.getInstance().reset();
            DataSourceRepositoryHolder.getInstance().getDataSourceRepositoryManager().clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (PriorityExecutor priorityExecutor : this.executors.values()) {
            priorityExecutor.destroy();
        }
        for (MessageProcessor messageProcessor : this.messageProcessors.values()) {
            if (messageProcessor instanceof AbstractMessageProcessor) {
                ((AbstractMessageProcessor)messageProcessor).destroy(preserverState);
                continue;
            }
            messageProcessor.destroy();
        }
        for (MessageStore messageStore : this.messageStores.values()) {
            if (messageStore instanceof AbstractMessageProcessor) {
                ((AbstractMessageProcessor)((Object)messageStore)).destroy(preserverState);
                continue;
            }
            messageStore.destroy();
        }
        for (API aPI : this.apiTable.values()) {
            aPI.destroy();
        }
    }

    @Override
    public synchronized void init(SynapseEnvironment se) {
        SynapseConfiguration previouseConfiguration = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the Synapse Configuration using the SynapseEnvironment");
        }
        if (this.registry != null && this.registry instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.registry)).init(se);
        }
        this.initCarbonTenantConfigurator(se);
        for (Endpoint endpoint : this.getDefinedEndpoints().values()) {
            try {
                endpoint.init(se);
            }
            catch (Exception exception) {
                log.error((Object)(" Error in initializing endpoint [" + endpoint.getName() + "] " + exception.getMessage()));
            }
        }
        for (TemplateMediator seqTemplate : this.getSequenceTemplates().values()) {
            try {
                seqTemplate.init(se);
            }
            catch (Exception exception) {
                log.error((Object)(" Error in initializing Sequence Template [" + seqTemplate.getName() + "] " + exception.getMessage()));
            }
        }
        String tenantDomain = this.getTenantDomain(se);
        if (tenantDomain != null) {
            previouseConfiguration = SynapseConfigUtils.getSynapseConfiguration(tenantDomain);
            SynapseConfigUtils.addSynapseConfiguration(tenantDomain, this);
        }
        if (previouseConfiguration != null) {
            this.destroyExistingInbounds(previouseConfiguration);
        }
        for (InboundEndpoint inboundEndpoint : this.getInboundEndpoints()) {
            try {
                inboundEndpoint.init(se);
            }
            catch (Exception e) {
                this.inboundEndpointMap.remove(inboundEndpoint.getName());
                log.error((Object)(" Error in initializing inbound endpoint [" + inboundEndpoint.getName() + "] " + e.getMessage()));
            }
        }
        for (ManagedLifecycle managedLifecycle : this.getDefinedSequences().values()) {
            if (managedLifecycle == null) continue;
            try {
                managedLifecycle.init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Sequence " + e.getMessage()));
            }
        }
        for (ProxyService proxyService : this.getProxyServices()) {
            try {
                if (proxyService.getTargetInLineEndpoint() != null) {
                    proxyService.getTargetInLineEndpoint().init(se);
                }
                if (proxyService.getTargetInLineInSequence() != null) {
                    proxyService.getTargetInLineInSequence().init(se);
                }
                if (proxyService.getTargetInLineOutSequence() != null) {
                    proxyService.getTargetInLineOutSequence().init(se);
                }
                if (proxyService.getTargetInLineFaultSequence() == null) continue;
                proxyService.getTargetInLineFaultSequence().init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Proxy Service [ " + proxyService.getName() + "] " + e.getMessage()));
            }
        }
        for (ManagedLifecycle managedLifecycle : this.getStartups()) {
            if (managedLifecycle == null) continue;
            try {
                managedLifecycle.init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Stratups " + e.getMessage()));
            }
        }
        for (PriorityExecutor priorityExecutor : this.getPriorityExecutors().values()) {
            try {
                priorityExecutor.init();
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Executor [ " + priorityExecutor.getName() + "] " + e.getMessage()));
            }
        }
        for (MessageStore messageStore : this.messageStores.values()) {
            try {
                messageStore.init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Message Store [ " + messageStore.getName() + "] " + e.getMessage()));
            }
        }
        for (MessageProcessor messageProcessor : this.messageProcessors.values()) {
            try {
                messageProcessor.init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing Message Processor [ " + messageProcessor.getName() + "] " + e.getMessage()));
            }
        }
        for (API aPI : this.apiTable.values()) {
            try {
                aPI.init(se);
            }
            catch (Exception e) {
                log.error((Object)(" Error in initializing API [ " + aPI.getName() + "] " + e.getMessage()));
            }
        }
        this.initImportedLibraries(se);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public synchronized void addEventSource(String name, SynapseEventSource eventSource) {
        if (!this.eventSources.containsKey(name)) {
            this.eventSources.put(name, eventSource);
            for (SynapseObserver o : this.observers) {
                o.eventSourceAdded(eventSource);
            }
        } else {
            this.handleException("Duplicate event source by the name : " + name);
        }
    }

    public SynapseEventSource getEventSource(String name) {
        return this.eventSources.get(name);
    }

    public synchronized void removeEventSource(String name) {
        SynapseEventSource eventSource = this.eventSources.get(name);
        if (eventSource == null) {
            this.handleException("No event source exists by the name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.eventSources.remove(name);
                for (SynapseObserver o : this.observers) {
                    o.eventSourceRemoved(eventSource);
                }
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection<SynapseEventSource> getEventSources() {
        return this.eventSources.values();
    }

    public void setEventSources(Map<String, SynapseEventSource> eventSources) {
        this.eventSources = eventSources;
    }

    public void registerObserver(SynapseObserver o) {
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public List<SynapseObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public void unregisterObserver(SynapseObserver observer) {
        this.removableObservers.add(observer);
    }

    public synchronized void addPriorityExecutor(String name, PriorityExecutor executor) {
        if (!this.executors.containsKey(name)) {
            this.executors.put(name, executor);
            for (SynapseObserver o : this.observers) {
                o.priorityExecutorAdded(executor);
            }
        } else {
            this.handleException("Duplicate priority executor by the name: " + name);
        }
    }

    public synchronized void updatePriorityExecutor(String name, PriorityExecutor executor) {
        this.executors.put(name, executor);
        for (SynapseObserver o : this.observers) {
            o.priorityExecutorAdded(executor);
        }
    }

    public Map<String, PriorityExecutor> getPriorityExecutors() {
        return this.executors;
    }

    public synchronized PriorityExecutor removeExecutor(String name) {
        PriorityExecutor executor = this.executors.remove(name);
        if (executor != null) {
            for (SynapseObserver o : this.observers) {
                o.priorityExecutorRemoved(executor);
            }
        }
        return executor;
    }

    public MessageStore getMessageStore(String name) {
        return this.messageStores.get(name);
    }

    public void addMessageStore(String name, MessageStore messageStore) {
        if (!this.messageStores.containsKey(name)) {
            this.messageStores.put(name, messageStore);
            Set<String> processors = this.messageProcessors.keySet();
            for (String processorName : processors) {
                if (!this.messageProcessors.get(processorName).getMessageStoreName().equals(name)) continue;
                this.messageProcessors.get(processorName).start();
            }
        } else {
            this.handleException("Duplicate message store : " + name);
        }
    }

    public Map<String, MessageStore> getMessageStores() {
        return this.messageStores;
    }

    public MessageStore removeMessageStore(String name) {
        Set<String> processors = this.messageProcessors.keySet();
        for (String processorName : processors) {
            if (!this.messageProcessors.get(processorName).getMessageStoreName().equals(name)) continue;
            this.messageProcessors.get(processorName).destroy();
        }
        return this.messageStores.remove(name);
    }

    public void addMessageProcessor(String name, MessageProcessor processor) {
        if (!this.messageProcessors.containsKey(name)) {
            this.messageProcessors.put(name, processor);
        } else {
            this.handleException("Duplicate Message Processor " + name);
        }
    }

    public Map<String, MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public MessageProcessor removeMessageProcessor(String name) {
        return this.messageProcessors.remove(name);
    }

    public void addSynapseLibrary(String name, Library library) {
        if (!this.synapseLibraries.containsKey(name)) {
            this.synapseLibraries.put(name, library);
            for (SynapseObserver o : this.observers) {
                o.synapseLibraryAdded(library);
            }
        } else {
            this.handleException("Duplicate Synapse Library " + name);
        }
    }

    public Map<String, Library> getSynapseLibraries() {
        return this.synapseLibraries;
    }

    public Library removeSynapseLibrary(String name) {
        Library removedLib = this.synapseLibraries.remove(name);
        if (removedLib != null) {
            for (SynapseObserver o : this.observers) {
                o.synapseLibraryRemoved(removedLib);
            }
            this.observers.removeAll(this.removableObservers);
            this.removableObservers.clear();
        }
        return removedLib;
    }

    public void addSynapseImport(String name, SynapseImport synImport) {
        this.synapseImports.put(name, synImport);
    }

    public Map<String, SynapseImport> getSynapseImports() {
        return this.synapseImports;
    }

    public SynapseImport removeSynapseImport(String name) {
        return this.synapseImports.remove(name);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public SynapseArtifactDeploymentStore getArtifactDeploymentStore() {
        return this.artifactDeploymentStore;
    }

    public Map<String, Object> getDecryptedCacheMap() {
        return this.decryptedCacheMap;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    private void assertAlreadyExists(String key, String type) {
        if (key == null || "".equals(key)) {
            this.handleException("Given entry key is empty or null.");
        }
        if (this.localRegistry.containsKey(key.trim()) && this.localRegistry.get(key.trim()) instanceof Entry && ((Entry)this.localRegistry.get(key.trim())).getValue() != null) {
            this.handleException("Duplicate " + type + " definition for key : " + key);
        }
    }

    private void assertEntryNull(Entry entry, String key) {
        if (entry == null) {
            this.handleException("Cannot locate an either local or remote entry for key : " + key);
        }
    }

    public void addEndpointTemplate(String name, Template template) {
        this.assertAlreadyExists(name, "template");
        this.localRegistry.put(name, template);
    }

    public void updateEndpointTemplate(String name, Template template) {
        this.localRegistry.put(name, template);
    }

    public void removeEndpointTemplate(String name) {
        Object sequence = this.localRegistry.get(name);
        if (sequence instanceof Template) {
            this.localRegistry.remove(name);
        } else {
            this.handleException("No template exists by the key/name : " + name);
        }
    }

    public Template getEndpointTemplate(String key) {
        Template templateFromLib;
        Object o = this.getEntry(key);
        if (o instanceof Template) {
            return (Template)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(new XMLToTemplateMapper(this));
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                Template m;
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Template) {
                    this.localRegistry.put(key, entry);
                    return (Template)o;
                }
                if (o instanceof OMNode && (m = new TemplateFactory().createEndpointTemplate((OMElement)o, this.properties)) != null) {
                    entry.setValue(m);
                    return m;
                }
            }
        } else {
            Object object;
            Object value = entry.getValue();
            if (value instanceof OMNode && (object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties())) instanceof Template) {
                entry.setValue(object);
                return (Template)object;
            }
        }
        if ((templateFromLib = LibDeployerUtils.getLibArtifact(this.synapseLibraries, key, Template.class)) != null) {
            return templateFromLib;
        }
        return null;
    }

    public Mediator getDefaultConfiguration(String key) {
        Object o = this.getEntry(key);
        if (o instanceof Mediator) {
            return (Mediator)o;
        }
        Entry entry = null;
        if (o == null) {
            entry = new Entry(key);
            entry.setType(3);
        } else {
            Object object = this.localRegistry.get(key);
            if (object instanceof Entry) {
                entry = (Entry)object;
            }
        }
        this.assertEntryNull(entry, key);
        if (entry.getMapper() == null) {
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (entry.getType() == 3) {
            if (this.registry != null) {
                o = this.registry.getResource(entry, this.getProperties());
                if (o != null && o instanceof Mediator) {
                    this.localRegistry.put(key, entry);
                    return (Mediator)o;
                }
                if (o instanceof OMNode) {
                    this.properties.put("SynapseConfiguration", this);
                    Mediator m = (Mediator)MediatorFactoryFinder.getInstance().getObjectFromOMNode((OMNode)o, this.properties);
                    if (m != null) {
                        entry.setValue(m);
                        return m;
                    }
                }
            }
        } else {
            Object value = entry.getValue();
            if (value instanceof OMNode) {
                this.properties.put("SynapseConfiguration", this);
                Object object = entry.getMapper().getObjectFromOMNode((OMNode)value, this.getProperties());
                if (object instanceof Mediator) {
                    return (Mediator)object;
                }
            }
        }
        return null;
    }

    public boolean isAllowHotUpdate() {
        return this.allowHotUpdate;
    }

    public void setAllowHotUpdate(boolean allowHotUpdate) {
        this.allowHotUpdate = allowHotUpdate;
    }

    private void initCarbonTenantConfigurator(SynapseEnvironment se) {
        Axis2SynapseEnvironment axis2SynapseEnvironment = (Axis2SynapseEnvironment)se;
        TenantInfoConfigurator configurator = TenantInfoConfigProvider.getConfigurator();
        axis2SynapseEnvironment.setTenantInfoConfigurator(configurator);
        TenantInfoInitiator tenantInfoInitiator = TenantInfoInitiatorProvider.getTenantInfoInitiator();
        axis2SynapseEnvironment.setTenantInfoInitiator(tenantInfoInitiator);
    }

    private void initImportedLibraries(SynapseEnvironment synapseEnvironment) {
        for (String importKey : this.synapseImports.keySet()) {
            Library lib = this.synapseLibraries.get(importKey);
            if (lib == null) {
                log.error((Object)("Unable to deploy synapse import:" + importKey + ". Required library not found."));
                continue;
            }
            for (String artifactKey : lib.getArtifacts().keySet()) {
                if (!(lib.getArtifacts().get(artifactKey) instanceof TemplateMediator)) continue;
                ((TemplateMediator)lib.getArtifacts().get(artifactKey)).init(synapseEnvironment);
            }
        }
    }

    private void destroyExistingInbounds(SynapseConfiguration synapseConfiguration) {
        Collection<InboundEndpoint> inboundEndpoints = synapseConfiguration.getInboundEndpoints();
        for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
            if ("cxf_ws_rm".equals(inboundEndpoint.getProtocol())) continue;
            inboundEndpoint.destroy();
        }
    }

    private String getTenantDomain(SynapseEnvironment synapseEnvironment) {
        TenantInfoConfigurator configurator = synapseEnvironment.getTenantInfoConfigurator();
        if (configurator != null) {
            MessageContext axisMessageContext = new MessageContext();
            Axis2MessageContext messageContext = new Axis2MessageContext(axisMessageContext, this, synapseEnvironment);
            configurator.extractTenantInfo(messageContext);
            if (messageContext.getProperty("tenant.info.domain") != null) {
                return (String)messageContext.getProperty("tenant.info.domain");
            }
        }
        return null;
    }

    public List<String> getCommentedTextList() {
        return this.commentedTextList;
    }

    public void addToCommentedTextList(String comment) {
        if (comment != null && comment.length() > 0) {
            this.commentedTextList.add(comment);
        }
    }

    public CompletedStructureStore getCompletedStructureStore() {
        return this.completedStructureStore;
    }

    public synchronized void reconstructAPITable() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start re-constructing the API Table...");
        }
        Stream sorted = this.apiTable.entrySet().stream().sorted(Map.Entry.comparingByValue((api1, api2) -> api2.getContext().length() - api1.getContext().length()));
        this.apiTable = sorted.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        this.apiTable = this.getReConstructedApiMap(this.apiTable);
        this.reconstructBindsToMappings();
    }

    private Map<String, API> getReConstructedApiMap(Map<String, API> originalApiMap) {
        Stream sorted = originalApiMap.entrySet().stream().sorted(Map.Entry.comparingByValue((api1, api2) -> api2.getContext().length() - api1.getContext().length()));
        return sorted.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private synchronized void reconstructBindsToMappings() {
        Map<String, Map<String, API>> duplicateInboundApiMappings = Collections.synchronizedMap(new LinkedHashMap());
        for (Map.Entry<String, Map<String, API>> mapping : this.apiTableWithBindsTo.entrySet()) {
            Map<String, API> apis = mapping.getValue();
            Map<String, API> reconstructedApis = this.getReConstructedApiMap(apis);
            duplicateInboundApiMappings.put(mapping.getKey(), reconstructedApis);
        }
        this.apiTableWithBindsTo = duplicateInboundApiMappings;
    }
}

