/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.carbonext;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.config.SynapsePropertiesLoader;

public final class TenantInfoConfigProvider {
    public static final String CARBON_TENANT_INFO_CONFIGURATOR = "synapse.carbon.ext.tenant.info";
    private static final Log logger = LogFactory.getLog((String)TenantInfoConfigProvider.class.getName());

    public static TenantInfoConfigurator getConfigurator() {
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        String property = properties.getProperty(CARBON_TENANT_INFO_CONFIGURATOR);
        if (property != null) {
            try {
                Class<?> clazz = TenantInfoConfigProvider.class.getClassLoader().loadClass(property.trim());
                TenantInfoConfigurator obj = (TenantInfoConfigurator)clazz.newInstance();
                return obj;
            }
            catch (Exception e) {
                logger.error((Object)("Error while initializing tenant info configuration provider. Error:" + e.getLocalizedMessage()));
            }
        }
        return null;
    }
}

