/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticsLog;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingEvent;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingFlow;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingPayload;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingPayloadEvent;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class TracingDataCollectionHelper {
    public static String collectPayload(MessageContext messageContext) {
        String payload = null;
        try {
            org.apache.axis2.context.MessageContext a2mc = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)a2mc, (boolean)false);
            payload = JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)a2mc) ? JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)a2mc) : messageContext.getEnvelope().toString();
        }
        catch (Exception e) {
            payload = "NONE";
        }
        return payload;
    }

    public static Map<String, Object> extractContextProperties(MessageContext synCtx) {
        Set propertySet = synCtx.getPropertyKeySet();
        TreeMap<String, Object> propertyMap = new TreeMap<String, Object>();
        for (String property : propertySet) {
            Object propertyValue = synCtx.getProperty(property);
            propertyMap.put(property, propertyValue);
        }
        propertyMap.remove("synapse.statistics.stack");
        propertyMap.remove("STATISTIC_COLLECTOR");
        return propertyMap;
    }

    public static Map<String, Object> extractTransportProperties(MessageContext synCtx) {
        TreeMap<String, Object> transportPropertyMap = new TreeMap<String, Object>();
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        if (headers != null && headers instanceof Map) {
            Map headersMap = (Map)headers;
            Set axis2PropertySet = headersMap.keySet();
            for (String entry : axis2PropertySet) {
                transportPropertyMap.put(entry, headersMap.get(entry));
            }
        }
        if (axis2MessageCtx.getTo() != null) {
            transportPropertyMap.put("To", axis2MessageCtx.getTo().getAddress());
        }
        if (axis2MessageCtx.getFrom() != null) {
            transportPropertyMap.put("From", axis2MessageCtx.getFrom().getAddress());
        }
        if (axis2MessageCtx.getWSAAction() != null) {
            transportPropertyMap.put("WSAction", axis2MessageCtx.getWSAAction());
        }
        if (axis2MessageCtx.getSoapAction() != null) {
            transportPropertyMap.put("SOAPAction", axis2MessageCtx.getSoapAction());
        }
        if (axis2MessageCtx.getReplyTo() != null) {
            transportPropertyMap.put("ReplyTo", axis2MessageCtx.getReplyTo().getAddress());
        }
        if (axis2MessageCtx.getMessageID() != null) {
            transportPropertyMap.put("MessageID", axis2MessageCtx.getMessageID());
        }
        if (transportPropertyMap.get("Cookie") != null) {
            transportPropertyMap.remove("Cookie");
        }
        return transportPropertyMap;
    }

    public static PublishingFlow createPublishingFlow(List<StatisticsLog> messageFlowLogs) {
        PublishingFlow publishingFlow = new PublishingFlow();
        HashMap<String, PublishingPayload> payloadMap = new HashMap<String, PublishingPayload>();
        String REFER = "#REFER:";
        String BEFORE = "before-";
        String AFTER = "after-";
        Integer BEFORE_PAYLOAD = 8;
        Integer AFTER_PAYLOAD = 9;
        String entryPoint = messageFlowLogs.get(0).getComponentName();
        String flowId = messageFlowLogs.get(0).getMessageFlowId();
        Integer entrypointHashcode = messageFlowLogs.get(0).getHashCode();
        boolean isTracingEnabledForFlow = messageFlowLogs.get(0).isTracingEnabled();
        for (int index = 0; index < messageFlowLogs.size(); ++index) {
            StatisticsLog currentStatLog = messageFlowLogs.get(index);
            if (currentStatLog == null) continue;
            publishingFlow.addEvent(new PublishingEvent(flowId, index, currentStatLog, entryPoint, entrypointHashcode));
            if (!RuntimeStatisticCollector.isCollectingPayloads() || !isTracingEnabledForFlow) continue;
            List<Integer> childrenOfCurrent = currentStatLog.getChildren();
            for (Integer child : childrenOfCurrent) {
                messageFlowLogs.get(child).setImmediateParent(currentStatLog.getCurrentIndex());
            }
            if (currentStatLog.getBeforePayload() != null && currentStatLog.getAfterPayload() == null) {
                currentStatLog.setAfterPayload(currentStatLog.getBeforePayload());
            }
            if (currentStatLog.getBeforePayload() == null) {
                int parentIndex = currentStatLog.getImmediateParent();
                StatisticsLog parentStatLog = messageFlowLogs.get(parentIndex);
                if (parentStatLog.getAfterPayload().startsWith("#REFER:")) {
                    currentStatLog.setBeforePayload(parentStatLog.getAfterPayload());
                    currentStatLog.setAfterPayload(parentStatLog.getAfterPayload());
                    String referringIndex = parentStatLog.getAfterPayload().split(":")[1];
                    ((PublishingPayload)payloadMap.get("after-" + referringIndex)).addEvent(new PublishingPayloadEvent(index, BEFORE_PAYLOAD));
                    ((PublishingPayload)payloadMap.get("after-" + referringIndex)).addEvent(new PublishingPayloadEvent(index, AFTER_PAYLOAD));
                    continue;
                }
                currentStatLog.setBeforePayload("#REFER:" + parentIndex);
                currentStatLog.setAfterPayload("#REFER:" + parentIndex);
                ((PublishingPayload)payloadMap.get("after-" + parentIndex)).addEvent(new PublishingPayloadEvent(index, BEFORE_PAYLOAD));
                ((PublishingPayload)payloadMap.get("after-" + parentIndex)).addEvent(new PublishingPayloadEvent(index, AFTER_PAYLOAD));
                continue;
            }
            PublishingPayload publishingPayloadBefore = new PublishingPayload();
            publishingPayloadBefore.setPayload(currentStatLog.getBeforePayload());
            publishingPayloadBefore.addEvent(new PublishingPayloadEvent(index, BEFORE_PAYLOAD));
            payloadMap.put("before-" + index, publishingPayloadBefore);
            PublishingPayload publishingPayloadAfter = new PublishingPayload();
            publishingPayloadAfter.setPayload(currentStatLog.getAfterPayload());
            publishingPayloadAfter.addEvent(new PublishingPayloadEvent(index, AFTER_PAYLOAD));
            payloadMap.put("after-" + index, publishingPayloadAfter);
        }
        publishingFlow.setMessageFlowId(flowId);
        publishingFlow.setPayloads(payloadMap.values());
        return publishingFlow;
    }
}

