/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.util.TracingDataCollectionHelper;
import org.apache.synapse.aspects.flow.statistics.util.UniqueIdentifierObject;

public class StatisticDataCollectionHelper {
    public static String getStatisticTraceId(MessageContext messageContext) {
        return (String)messageContext.getProperty("mediation.flow.statistics.statistic.id") + System.nanoTime();
    }

    public static int getFlowPosition(MessageContext messageContext) {
        UniqueIdentifierObject uniqueIdentifierObject = (UniqueIdentifierObject)messageContext.getProperty("mediation.flow.statistics.index.object");
        if (uniqueIdentifierObject == null) {
            uniqueIdentifierObject = new UniqueIdentifierObject();
            messageContext.setProperty("mediation.flow.statistics.index.object", uniqueIdentifierObject);
            return uniqueIdentifierObject.getCurrentLevel();
        }
        return uniqueIdentifierObject.getNextIndex();
    }

    public static int getParentFlowPosition(MessageContext messageContext, Integer newParentIndex) {
        Integer parentIndex = (Integer)messageContext.getProperty("mediation.flow.statistics.parent.index");
        if (newParentIndex != null) {
            messageContext.setProperty("mediation.flow.statistics.parent.index", newParentIndex);
        }
        if (parentIndex == null) {
            return -1;
        }
        return parentIndex;
    }

    public static List<Integer> getParentList(MessageContext messageContext) {
        Object parentList = messageContext.getProperty("mediation.flow.statistics.parent.list");
        if (parentList != null) {
            messageContext.setProperty("mediation.flow.statistics.parent.list", new LinkedList());
            return (List)parentList;
        }
        return null;
    }

    public static boolean isOutOnlyFlow(MessageContext messageContext) {
        return "true".equals(messageContext.getProperty("OUT_ONLY"));
    }

    public static void collectData(MessageContext messageContext, boolean isContentAltering, Boolean isCollectingTracing, StatisticDataUnit statisticDataUnit) {
        statisticDataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(messageContext));
        statisticDataUnit.setSynapseEnvironment(messageContext.getEnvironment());
        statisticDataUnit.setParentList(StatisticDataCollectionHelper.getParentList(messageContext));
        statisticDataUnit.setTime(System.currentTimeMillis());
        if (isCollectingTracing != null && isCollectingTracing.booleanValue()) {
            if (RuntimeStatisticCollector.isCollectingPayloads() && isContentAltering) {
                statisticDataUnit.setPayload(TracingDataCollectionHelper.collectPayload(messageContext));
            }
            if (RuntimeStatisticCollector.isCollectingProperties()) {
                statisticDataUnit.setContextPropertyMap(TracingDataCollectionHelper.extractContextProperties(messageContext));
                statisticDataUnit.setTransportPropertyMap(TracingDataCollectionHelper.extractTransportProperties(messageContext));
            }
        }
    }

    public static void collectAggregatedParents(List<MessageContext> messages, MessageContext newCtx) {
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            LinkedList<Integer> aggregateParents = new LinkedList<Integer>();
            for (MessageContext synCtx : messages) {
                if (!RuntimeStatisticCollector.shouldReportStatistic(synCtx)) continue;
                aggregateParents.add(StatisticDataCollectionHelper.getParentFlowPosition(synCtx, null));
            }
            newCtx.setProperty("mediation.flow.statistics.parent.list", aggregateParents);
        }
    }
}

