/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.store;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.flow.statistics.log.StatisticsReportingEventHolder;

public class MessageDataStore {
    private static Log log = LogFactory.getLog(MessageDataStore.class);
    private Queue<StatisticsReportingEventHolder> queue = new ConcurrentLinkedQueue<StatisticsReportingEventHolder>();

    public void enqueue(StatisticsReportingEventHolder statisticsReportingEventHolder) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding eventHolder: " + statisticsReportingEventHolder));
            }
            this.queue.add(statisticsReportingEventHolder);
        }
        catch (Exception e) {
            log.error((Object)"Error adding statistic event holder to the Queue. Dropping statistics events.");
        }
    }

    public StatisticsReportingEventHolder dequeue() throws Exception {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Polling statistics event holder object from the Queue");
            }
            return this.queue.poll();
        }
        catch (Exception e) {
            log.error((Object)"Error polling statistics event holder objects from Queue");
            return null;
        }
    }
}

