/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.publishing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticsLog;

public class PublishingEvent {
    private String flowId;
    private String componentType;
    private String componentName;
    private Integer componentIndex;
    private String componentId;
    private long startTime;
    private long endTime;
    private long duration;
    private String beforePayload;
    private String afterPayload;
    private Map contextPropertyMap;
    private Map transportPropertyMap;
    private Integer[] children;
    private String entryPoint;
    private Integer entryPointHashcode;
    private int faultCount;
    private Integer hashCode;

    public PublishingEvent() {
    }

    public PublishingEvent(String flowId, int componentIndex, StatisticsLog statisticsLog, String entryPoint, Integer entryPointHashcode) {
        this.flowId = flowId;
        this.componentType = statisticsLog.getComponentTypeToString();
        this.componentName = statisticsLog.getComponentName();
        this.componentIndex = componentIndex;
        this.componentId = statisticsLog.getComponentId();
        this.startTime = statisticsLog.getStartTime();
        this.endTime = statisticsLog.getEndTime();
        this.duration = this.endTime - this.startTime;
        this.contextPropertyMap = this.extractProperties(statisticsLog.getContextPropertyMap());
        this.transportPropertyMap = this.extractProperties(statisticsLog.getTransportPropertyMap());
        if (statisticsLog.getChildren().size() > 0) {
            this.children = new Integer[statisticsLog.getChildren().size()];
            this.children = statisticsLog.getChildren().toArray(this.children);
        }
        this.entryPoint = entryPoint;
        this.entryPointHashcode = entryPointHashcode;
        this.faultCount = statisticsLog.getNoOfFaults();
        this.hashCode = statisticsLog.getHashCode();
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Integer getComponentIndex() {
        return this.componentIndex;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getBeforePayload() {
        return this.beforePayload;
    }

    public void setBeforePayload(String beforePayload) {
        this.beforePayload = beforePayload;
    }

    public String getAfterPayload() {
        return this.afterPayload;
    }

    public void setAfterPayload(String afterPayload) {
        this.afterPayload = afterPayload;
    }

    public Map getContextPropertyMap() {
        return this.contextPropertyMap;
    }

    public void setContextPropertyMap(Map contextPropertyMap) {
        this.contextPropertyMap = contextPropertyMap;
    }

    public Map getTransportPropertyMap() {
        return this.transportPropertyMap;
    }

    public void setTransportPropertyMap(Map transportPropertyMap) {
        this.transportPropertyMap = transportPropertyMap;
    }

    public Integer[] getChildren() {
        return this.children;
    }

    public void setChildren(Integer[] children) {
        this.children = children;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public int getFaultCount() {
        return this.faultCount;
    }

    public void setFaultCount(int faultCount) {
        this.faultCount = faultCount;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public Integer getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(Integer hashCode) {
        this.hashCode = hashCode;
    }

    public Integer getEntryPointHashcode() {
        return this.entryPointHashcode;
    }

    public void setEntryPointHashcode(Integer entryPointHashcode) {
        this.entryPointHashcode = entryPointHashcode;
    }

    public String toString() {
        return "Component Type " + this.componentType + " , Component Name " + this.componentName;
    }

    private Map<String, Object> extractProperties(Map<String, Object> originalMap) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        if (originalMap == null) {
            return null;
        }
        for (Map.Entry<String, Object> anEntry : originalMap.entrySet()) {
            Object entryValue = anEntry.getValue();
            if (entryValue instanceof String || entryValue instanceof Boolean || entryValue instanceof Integer || entryValue instanceof Double || entryValue instanceof Character) {
                copy.put(anEntry.getKey(), entryValue);
                continue;
            }
            try {
                copy.put(anEntry.getKey(), anEntry.getValue().toString());
            }
            catch (Exception ignore) {
                copy.put(anEntry.getKey(), "Value cannot be serialized");
            }
        }
        return copy;
    }

    public ArrayList<Object> getObjectAsList() {
        ArrayList<Object> objectList = new ArrayList<Object>();
        objectList.add(this.flowId);
        objectList.add(this.componentType);
        objectList.add(this.componentName);
        objectList.add(this.componentIndex);
        objectList.add(this.componentId);
        objectList.add(this.startTime);
        objectList.add(this.endTime);
        objectList.add(this.duration);
        objectList.add(this.beforePayload);
        objectList.add(this.afterPayload);
        if (this.contextPropertyMap == null) {
            objectList.add(null);
        } else {
            objectList.add(this.contextPropertyMap.toString());
        }
        if (this.transportPropertyMap == null) {
            objectList.add(null);
        } else {
            objectList.add(this.transportPropertyMap.toString());
        }
        objectList.add(Arrays.toString((Object[])this.children));
        objectList.add(this.entryPoint);
        objectList.add(String.valueOf(this.entryPointHashcode));
        objectList.add(this.faultCount);
        objectList.add(String.valueOf(this.hashCode));
        return objectList;
    }
}

