/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.stores;

import io.opentracing.Span;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.SpanTagger;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.TracingUtils;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.ContinuationStateSequenceInfo;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;

public class SpanStore {
    private SpanWrapper outerLevelSpan = null;
    private Map<String, SpanWrapper> spanWrappers = new LinkedHashMap<String, SpanWrapper>();
    private List<SpanWrapper> activeSpanWrappers = new ArrayList<SpanWrapper>();
    private Map<String, SpanWrapper> componentUniqueIdWiseSpanWrappers = new HashMap<String, SpanWrapper>();
    private List<ContinuationStateSequenceInfo> continuationStateSequenceInfos = new Stack<ContinuationStateSequenceInfo>();

    public SpanWrapper addSpanWrapper(String spanId, Span activeSpan, StatisticDataUnit statisticDataUnit, SpanWrapper parentSpanWrapper, MessageContext synCtx) {
        SpanWrapper spanWrapper = new SpanWrapper(spanId, activeSpan, statisticDataUnit, parentSpanWrapper);
        this.spanWrappers.put(spanId, spanWrapper);
        spanWrapper.addKnownSynCtxHashCodeToAllParents(TracingUtils.getSystemIdentityHashCode(synCtx));
        if (parentSpanWrapper != null) {
            parentSpanWrapper.addChildComponentUniqueId(statisticDataUnit.getComponentId());
            if (TracingUtils.isAnonymousSequence(spanWrapper.getStatisticDataUnit())) {
                parentSpanWrapper.addAnonymousSequence(spanId, spanWrapper);
            }
        }
        this.componentUniqueIdWiseSpanWrappers.put(statisticDataUnit.getComponentId(), spanWrapper);
        this.activeSpanWrappers.add(spanWrapper);
        return spanWrapper;
    }

    public void finishSpan(SpanWrapper spanWrapper) {
        if (spanWrapper != null && spanWrapper.getSpan() != null) {
            if (spanWrapper.getStatisticDataUnit() != null) {
                SpanTagger.setSpanTags(spanWrapper);
            }
            spanWrapper.getSpan().finish();
            this.activeSpanWrappers.remove(spanWrapper);
        }
    }

    public void assignOuterLevelSpan(SpanWrapper spanWrapper) {
        this.outerLevelSpan = spanWrapper;
    }

    public SpanWrapper getOuterLevelSpanWrapper() {
        return this.outerLevelSpan;
    }

    public Map<String, SpanWrapper> getSpanWrappers() {
        return this.spanWrappers;
    }

    public SpanWrapper getSpanWrapper(String spanWrapperId) {
        return this.spanWrappers.get(spanWrapperId);
    }

    public List<SpanWrapper> getActiveSpanWrappers() {
        return this.activeSpanWrappers;
    }

    public SpanWrapper getSpanWrapperByComponentUniqueId(String componentUniqueId) {
        return this.componentUniqueIdWiseSpanWrappers.get(componentUniqueId);
    }

    public void addContinuationStateSequenceInfo(ContinuationStateSequenceInfo continuationStateSequenceInfo) {
        this.continuationStateSequenceInfos.add(continuationStateSequenceInfo);
    }

    public List<ContinuationStateSequenceInfo> getContinuationStateSequenceInfos() {
        return this.continuationStateSequenceInfos;
    }

    public boolean hasContinuationStateSequenceInfoWithId(String id) {
        for (ContinuationStateSequenceInfo activeCallMediatorSequence : this.continuationStateSequenceInfos) {
            if (!Objects.equals(id, activeCallMediatorSequence.getSpanReferenceId())) continue;
            return true;
        }
        return false;
    }
}

