/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.stores;

import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.aspects.flow.statistics.structuring.StructuringElement;

public class ArtifactHolderStore {
    private static ConcurrentMap<String, Stack<StructuringElement>> structuringElementStacks = new ConcurrentHashMap<String, Stack<StructuringElement>>();

    private ArtifactHolderStore() {
    }

    public static synchronized void addStructuringElementStack(String componentUniqueId, ArtifactHolder artifactHolderReference) {
        if (artifactHolderReference != null) {
            Stack<StructuringElement> stackCopy = ArtifactHolderStore.getCopiedStack(componentUniqueId, artifactHolderReference.getStack());
            structuringElementStacks.put(componentUniqueId, stackCopy);
        }
    }

    public static Stack<StructuringElement> getStructuringElementStack(String componentUniqueId) {
        if (componentUniqueId != null) {
            return (Stack)structuringElementStacks.get(componentUniqueId);
        }
        return null;
    }

    private static Stack<StructuringElement> getCopiedStack(String componentUniqueId, Stack<StructuringElement> stack) {
        Stack stackCopy = new Stack();
        if (structuringElementStacks.containsKey(componentUniqueId)) {
            stackCopy = (Stack)structuringElementStacks.get(componentUniqueId);
        }
        if (stack != null) {
            for (StructuringElement structuringElement : stack) {
                stackCopy.push(structuringElement);
            }
        }
        return stackCopy;
    }
}

