/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.models;

import io.opentracing.Span;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;

public class SpanWrapper {
    private String id;
    private Span span;
    private StatisticDataUnit openEventStatisticDataUnit;
    private StatisticDataUnit closeEventStatisticDataUnit;
    private SpanWrapper parentSpanWrapper;
    private final Map<String, SpanWrapper> anonymousSequences;
    private Set<String> knownSynCtxHashCodes;
    private Set<String> childStructuredElementIds;

    public SpanWrapper(String id, Span span, StatisticDataUnit openEventStatisticDataUnit, SpanWrapper parentSpanWrapper) {
        this.id = id;
        this.span = span;
        this.openEventStatisticDataUnit = openEventStatisticDataUnit;
        this.anonymousSequences = new LinkedHashMap<String, SpanWrapper>();
        this.parentSpanWrapper = parentSpanWrapper;
        this.childStructuredElementIds = new HashSet<String>();
        this.knownSynCtxHashCodes = new HashSet<String>();
    }

    public Span getSpan() {
        return this.span;
    }

    public StatisticDataUnit getStatisticDataUnit() {
        return this.openEventStatisticDataUnit;
    }

    public void setStatisticDataUnit(StatisticDataUnit statisticDataUnit) {
        this.openEventStatisticDataUnit = statisticDataUnit;
    }

    public StatisticDataUnit getCloseEventStatisticDataUnit() {
        return this.closeEventStatisticDataUnit;
    }

    public void setCloseEventStatisticDataUnit(StatisticDataUnit closeEventStatisticDataUnit) {
        this.closeEventStatisticDataUnit = closeEventStatisticDataUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnonymousSequence(String id, SpanWrapper anonymousSequenceSpanWrapper) {
        Map<String, SpanWrapper> map = this.anonymousSequences;
        synchronized (map) {
            this.anonymousSequences.put(id, anonymousSequenceSpanWrapper);
        }
    }

    public Map<String, SpanWrapper> getAnonymousSequences() {
        return this.anonymousSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanWrapper getLatestAnonymousSequence() {
        Map<String, SpanWrapper> map = this.anonymousSequences;
        synchronized (map) {
            if (!this.anonymousSequences.isEmpty()) {
                String[] keys = this.anonymousSequences.keySet().toArray(new String[0]);
                return this.anonymousSequences.get(keys[keys.length - 1]);
            }
            return null;
        }
    }

    public void addChildComponentUniqueId(String childStructuredElementId) {
        this.childStructuredElementIds.add(childStructuredElementId);
    }

    public Set<String> getChildStructuredElementIds() {
        return this.childStructuredElementIds;
    }

    public Set<String> getKnownSynCtxHashCodes() {
        return this.knownSynCtxHashCodes;
    }

    public void addKnownSynCtxHashCodeToAllParents(String synCtxHashCode) {
        this.knownSynCtxHashCodes.add(synCtxHashCode);
        if (this.parentSpanWrapper != null) {
            this.parentSpanWrapper.addKnownSynCtxHashCodeToAllParents(synCtxHashCode);
        }
    }
}

