/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping.TracingScope;

public class TracingScopeManager {
    private final Map<String, TracingScope> tracingScopes = new LinkedHashMap<String, TracingScope>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TracingScope getTracingScope(MessageContext synCtx) {
        Map<String, TracingScope> map = this.tracingScopes;
        synchronized (map) {
            String tracingScopeId = this.extractTracingScopeId(synCtx);
            if (this.tracingScopes.containsKey(tracingScopeId)) {
                return this.tracingScopes.get(tracingScopeId);
            }
            TracingScope parent = this.getLatestTracingScope();
            TracingScope tracingScope = new TracingScope(parent, tracingScopeId);
            this.tracingScopes.put(tracingScopeId, tracingScope);
            return tracingScope;
        }
    }

    private String extractTracingScopeId(MessageContext synCtx) {
        return (String)synCtx.getProperty("mediation.flow.statistics.statistic.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TracingScope getLatestTracingScope() {
        Map<String, TracingScope> map = this.tracingScopes;
        synchronized (map) {
            if (!this.tracingScopes.isEmpty()) {
                String[] keys = this.tracingScopes.keySet().toArray(new String[0]);
                return this.tracingScopes.get(keys[keys.length - 1]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupTracingScope(String tracingScopeId) {
        Map<String, TracingScope> map = this.tracingScopes;
        synchronized (map) {
            this.tracingScopes.remove(tracingScopeId);
        }
    }
}

