/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping;

import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.log.StatisticsReportingEventHolder;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;

public class TracingScope {
    private String tracingScopeId;
    private TracingScope parentScope;
    private final SpanStore spanStore;
    private Integer pendingCallbacksCount;

    public TracingScope(TracingScope parentScope, String tracingScopeId) {
        this.tracingScopeId = tracingScopeId;
        this.spanStore = new SpanStore();
        this.parentScope = parentScope;
        this.pendingCallbacksCount = 0;
    }

    public SpanStore getSpanStore() {
        return this.spanStore;
    }

    public void addCallback() {
        this.incrementPendingCallbacksCount();
        TracingScope parent = this.parentScope;
        while (parent != null) {
            parent.incrementPendingCallbacksCount();
            parent = parent.parentScope;
        }
    }

    public void removeCallback() {
        this.decrementPendingCallbacksCount();
        TracingScope parent = this.parentScope;
        while (parent != null) {
            parent.decrementPendingCallbacksCount();
            parent = parent.parentScope;
        }
    }

    private synchronized void incrementPendingCallbacksCount() {
        Integer n = this.pendingCallbacksCount;
        Integer n2 = this.pendingCallbacksCount = Integer.valueOf(this.pendingCallbacksCount + 1);
    }

    private synchronized void decrementPendingCallbacksCount() {
        if (this.pendingCallbacksCount > 0) {
            Integer n = this.pendingCallbacksCount;
            Integer n2 = this.pendingCallbacksCount = Integer.valueOf(this.pendingCallbacksCount - 1);
        }
    }

    public boolean isEventCollectionFinished(MessageContext synCtx) {
        return this.pendingCallbacksCount == 0 && synCtx.getProperty("STATISTIC_COLLECTOR") != null && ((StatisticsReportingEventHolder)synCtx.getProperty("STATISTIC_COLLECTOR")).isEvenCollectionFinished();
    }

    public String getTracingScopeId() {
        return this.tracingScopeId;
    }
}

