/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving;

import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.ArtifactHolderBasedParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.LatestActiveParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.MessageFlowRepresentationBasedParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;

public class ParentResolver {
    private ParentResolver() {
    }

    public static SpanWrapper resolveParent(StatisticDataUnit child, SpanStore spanStore, MessageContext synCtx) {
        SpanWrapper parent = MessageFlowRepresentationBasedParentResolver.resolveParent(child, spanStore);
        if (parent != null && parent.getSpan() != null) {
            return parent;
        }
        parent = ArtifactHolderBasedParentResolver.resolveParent(child, spanStore, synCtx);
        if (parent != null && parent.getSpan() != null) {
            return parent;
        }
        return LatestActiveParentResolver.resolveParent(spanStore);
    }
}

