/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving;

import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.TracingUtils;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.AbstractParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.LatestActiveParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;

public class MessageFlowRepresentationBasedParentResolver
extends AbstractParentResolver {
    public static SpanWrapper resolveParent(StatisticDataUnit child, SpanStore spanStore) {
        String parentId = String.valueOf(child.getParentIndex());
        SpanWrapper parent = spanStore.getSpanWrapper(parentId);
        if (parent != null) {
            if (MessageFlowRepresentationBasedParentResolver.isEndpointOrInboundEndpoint(child)) {
                if (MessageFlowRepresentationBasedParentResolver.isCallMediator(parent.getStatisticDataUnit()) || MessageFlowRepresentationBasedParentResolver.isSendMediator(parent.getStatisticDataUnit())) {
                    return parent;
                }
                return LatestActiveParentResolver.resolveParentForEndpointOrInboundEndpoint(spanStore);
            }
            if (TracingUtils.isAnonymousSequence(parent.getStatisticDataUnit()) || TracingUtils.isAnonymousSequence(child)) {
                if (MessageFlowRepresentationBasedParentResolver.isFlowContinuableMediator(parent.getStatisticDataUnit()) || MessageFlowRepresentationBasedParentResolver.isForeachMediator(parent.getStatisticDataUnit())) {
                    return parent;
                }
                return MessageFlowRepresentationBasedParentResolver.getLatestEligibleParent(spanStore);
            }
        }
        return null;
    }

    private static SpanWrapper getLatestEligibleParent(SpanStore spanStore) {
        Object[] spanWrapperKeys = spanStore.getSpanWrappers().keySet().toArray();
        for (int i = spanWrapperKeys.length - 1; i >= 0; --i) {
            String key = (String)spanWrapperKeys[i];
            SpanWrapper spanWrapper = spanStore.getSpanWrapper(key);
            if (!MessageFlowRepresentationBasedParentResolver.isFlowContinuableMediator(spanWrapper.getStatisticDataUnit()) && !MessageFlowRepresentationBasedParentResolver.isForeachMediator(spanWrapper.getStatisticDataUnit())) continue;
            return spanWrapper;
        }
        return null;
    }
}

