/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving;

import java.util.List;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.AbstractParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;

public class LatestActiveParentResolver
extends AbstractParentResolver {
    public static SpanWrapper resolveParent(SpanStore spanStore) {
        return LatestActiveParentResolver.resolveLatestActiveSpanWrapper(spanStore);
    }

    public static SpanWrapper resolveParentForEndpointOrInboundEndpoint(SpanStore spanStore) {
        List<SpanWrapper> parentableSpans = spanStore.getActiveSpanWrappers();
        for (int i = parentableSpans.size() - 1; i >= 0; --i) {
            SpanWrapper spanWrapper = parentableSpans.get(i);
            StatisticDataUnit statisticDataUnit = spanWrapper.getStatisticDataUnit();
            if (!LatestActiveParentResolver.isCallMediator(statisticDataUnit) && !LatestActiveParentResolver.isSendMediator(statisticDataUnit) && !LatestActiveParentResolver.isFlowContinuableMediator(statisticDataUnit)) continue;
            return spanWrapper;
        }
        return null;
    }

    private static SpanWrapper resolveLatestActiveSpanWrapper(SpanStore spanStore) {
        List<SpanWrapper> activeSpanWrappers = spanStore.getActiveSpanWrappers();
        if (activeSpanWrappers.isEmpty()) {
            return null;
        }
        return activeSpanWrappers.get(activeSpanWrappers.size() - 1);
    }
}

