/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.TracingUtils;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.AbstractParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.ArtifactHolderStore;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;
import org.apache.synapse.aspects.flow.statistics.structuring.StructuringElement;

public class ArtifactHolderBasedParentResolver
extends AbstractParentResolver {
    public static SpanWrapper resolveParent(StatisticDataUnit child, SpanStore spanStore, MessageContext synCtx) {
        String childUniqueId = child.getComponentId();
        Stack<StructuringElement> structuringElementStack = ArtifactHolderStore.getStructuringElementStack(childUniqueId);
        String parentComponentUniqueId = ArtifactHolderBasedParentResolver.getReportedParentComponentUniqueId(structuringElementStack);
        if (parentComponentUniqueId != null) {
            return ArtifactHolderBasedParentResolver.findSpanWrapperByComponentUniqueId(parentComponentUniqueId, child, spanStore, synCtx);
        }
        return null;
    }

    private static String getReportedParentComponentUniqueId(Stack<StructuringElement> structuringElementStack) {
        String parentComponentUniqueId = null;
        if (structuringElementStack != null && !structuringElementStack.isEmpty()) {
            parentComponentUniqueId = structuringElementStack.peek().getId();
        }
        return parentComponentUniqueId;
    }

    private static SpanWrapper findSpanWrapperByComponentUniqueId(String parentComponentUniqueId, StatisticDataUnit child, SpanStore spanStore, MessageContext childSynCtx) {
        SpanWrapper parent = spanStore.getSpanWrapperByComponentUniqueId(parentComponentUniqueId);
        if (parent != null) {
            if (!parent.getAnonymousSequences().isEmpty()) {
                return ArtifactHolderBasedParentResolver.resolveAnonymousSequence(parent, child, spanStore, childSynCtx);
            }
            if (!ArtifactHolderBasedParentResolver.isAlreadyAParent(parent, child.getComponentId())) {
                return parent;
            }
            for (SpanWrapper spanWrapper : spanStore.getSpanWrappers().values()) {
                if (!Objects.equals(parentComponentUniqueId, spanWrapper.getStatisticDataUnit().getComponentId()) || ArtifactHolderBasedParentResolver.isAlreadyAParent(spanWrapper, child.getComponentId())) continue;
                return spanWrapper;
            }
        }
        return parent;
    }

    private static boolean isAlreadyAParent(SpanWrapper parent, String childComponentUniqueId) {
        return parent.getChildStructuredElementIds().contains(childComponentUniqueId);
    }

    private static SpanWrapper resolveAnonymousSequence(SpanWrapper anonymousSequenceContainer, StatisticDataUnit child, SpanStore spanStore, MessageContext childSynCtx) {
        SpanWrapper parent = ArtifactHolderBasedParentResolver.resolveAnonymousSequenceFromKnownSynCtx(TracingUtils.getSystemIdentityHashCode(childSynCtx), anonymousSequenceContainer);
        if (parent != null) {
            return parent;
        }
        parent = ArtifactHolderBasedParentResolver.resolveAnonymousSequenceFromUnknownSynCtx(child, childSynCtx, anonymousSequenceContainer, spanStore);
        if (parent != null) {
            return parent;
        }
        return anonymousSequenceContainer.getLatestAnonymousSequence();
    }

    private static SpanWrapper resolveAnonymousSequenceFromKnownSynCtx(String synCtxHashCode, SpanWrapper anonymousSequenceContainer) {
        for (SpanWrapper anonymousSequence : anonymousSequenceContainer.getAnonymousSequences().values()) {
            if (!anonymousSequence.getKnownSynCtxHashCodes().contains(synCtxHashCode)) continue;
            return anonymousSequence;
        }
        return null;
    }

    private static SpanWrapper resolveAnonymousSequenceFromUnknownSynCtx(StatisticDataUnit child, MessageContext unknownSynCtx, SpanWrapper anonymousSequenceContainer, SpanStore spanStore) {
        HashSet<String> knownSynCtxHashCodes = new HashSet<String>();
        for (SpanWrapper anonymousSequence : anonymousSequenceContainer.getAnonymousSequences().values()) {
            knownSynCtxHashCodes.addAll(anonymousSequence.getKnownSynCtxHashCodes());
        }
        String knownSynCtxHashCode = ArtifactHolderBasedParentResolver.findKnownSynCtxHashCode(child, TracingUtils.getSystemIdentityHashCode(unknownSynCtx), knownSynCtxHashCodes, spanStore);
        if (knownSynCtxHashCode != null) {
            return ArtifactHolderBasedParentResolver.resolveAnonymousSequenceFromKnownSynCtx(knownSynCtxHashCode, anonymousSequenceContainer);
        }
        return null;
    }

    private static String findKnownSynCtxHashCode(StatisticDataUnit child, String unknownSynCtxHashCode, Set<String> knownSynCtxHashCodes, SpanStore spanStore) {
        SpanWrapper messageFlowParent = null;
        if (child != null) {
            messageFlowParent = spanStore.getSpanWrapper(String.valueOf(child.getParentIndex()));
        }
        while (messageFlowParent != null) {
            for (String synCtxIdentityHashCode : messageFlowParent.getKnownSynCtxHashCodes()) {
                if (!knownSynCtxHashCodes.contains(synCtxIdentityHashCode)) continue;
                messageFlowParent.addKnownSynCtxHashCodeToAllParents(unknownSynCtxHashCode);
                return synCtxIdentityHashCode;
            }
            messageFlowParent = spanStore.getSpanWrapper(String.valueOf(messageFlowParent.getStatisticDataUnit().getParentIndex()));
        }
        return null;
    }
}

