/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers;

import io.opentracing.Span;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticsLog;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;

public class SpanTagger {
    private SpanTagger() {
    }

    public static void setSpanTags(SpanWrapper spanWrapper) {
        StatisticsLog openStatisticsLog = new StatisticsLog(spanWrapper.getStatisticDataUnit());
        Span span = spanWrapper.getSpan();
        if (OpenTracingManagerHolder.isCollectingPayloads() || OpenTracingManagerHolder.isCollectingProperties()) {
            if (OpenTracingManagerHolder.isCollectingPayloads()) {
                if (openStatisticsLog.getBeforePayload() != null) {
                    span.setTag("beforePayload", openStatisticsLog.getBeforePayload());
                }
                if (spanWrapper.getCloseEventStatisticDataUnit() != null) {
                    span.setTag("afterPayload", spanWrapper.getCloseEventStatisticDataUnit().getPayload());
                } else {
                    span.setTag("afterPayload", openStatisticsLog.getBeforePayload());
                }
            }
            if (OpenTracingManagerHolder.isCollectingProperties()) {
                if (spanWrapper.getStatisticDataUnit().getContextPropertyMap() != null) {
                    span.setTag("beforeContextPropertyMap", spanWrapper.getStatisticDataUnit().getContextPropertyMap().toString());
                }
                if (spanWrapper.getCloseEventStatisticDataUnit() != null) {
                    if (spanWrapper.getCloseEventStatisticDataUnit().getContextPropertyMap() != null) {
                        span.setTag("afterContextPropertyMap", spanWrapper.getCloseEventStatisticDataUnit().getContextPropertyMap().toString());
                    }
                } else if (openStatisticsLog.getContextPropertyMap() != null) {
                    span.setTag("afterContextPropertyMap", openStatisticsLog.getContextPropertyMap().toString());
                }
                if (spanWrapper.getCloseEventStatisticDataUnit() != null && spanWrapper.getCloseEventStatisticDataUnit().getPropertyValue() != null) {
                    span.setTag("propertyMediatorValue", spanWrapper.getCloseEventStatisticDataUnit().getPropertyValue());
                }
            }
        }
        if (openStatisticsLog.getComponentName() != null) {
            span.setTag("componentName", openStatisticsLog.getComponentName());
        }
        if (openStatisticsLog.getComponentTypeToString() != null) {
            span.setTag("componentType", openStatisticsLog.getComponentTypeToString());
        }
        span.setTag("threadId", (Number)Thread.currentThread().getId());
        if (openStatisticsLog.getComponentId() != null) {
            span.setTag("componentId", openStatisticsLog.getComponentId());
        }
        if (openStatisticsLog.getHashCode() != null) {
            span.setTag("hashcode", (Number)openStatisticsLog.getHashCode());
        }
        if (openStatisticsLog.getTransportHeaderMap() != null) {
            span.setTag("Transport Headers", openStatisticsLog.getTransportHeaderMap().toString());
        }
        if (openStatisticsLog.getStatusCode() != null) {
            span.setTag("Status code", openStatisticsLog.getStatusCode());
        }
        if (openStatisticsLog.getStatusDescription() != null) {
            span.setTag("Status description", openStatisticsLog.getStatusDescription());
        }
        if (openStatisticsLog.getEndpoint() != null) {
            span.setTag("Endpoint", String.valueOf(openStatisticsLog.getEndpoint().getJsonRepresentation()));
        }
    }
}

