/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management.handling.span;

import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SequenceType;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.data.raw.BasicStatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.handling.span.OpenTracingSpanHandler;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.TracingUtils;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.parentresolving.ParentResolver;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping.TracingScope;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping.TracingScopeManager;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.ContinuationStateSequenceInfo;
import org.apache.synapse.aspects.flow.statistics.opentracing.models.SpanWrapper;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.SpanStore;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class JaegerSpanHandler
implements OpenTracingSpanHandler {
    private JaegerTracer tracer;
    private TracingScopeManager tracingScopeManager;

    public JaegerSpanHandler(JaegerTracer tracer, TracingScopeManager tracingScopeManager) {
        this.tracer = tracer;
        this.tracingScopeManager = tracingScopeManager;
    }

    @Override
    public void handleOpenEntryEvent(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        this.startSpanOrBufferSequenceContinuationState(statisticDataUnit, synCtx);
    }

    @Override
    public void handleOpenChildEntryEvent(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        this.startSpanOrBufferSequenceContinuationState(statisticDataUnit, synCtx);
    }

    @Override
    public void handleOpenFlowContinuableEvent(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        this.startSpanOrBufferSequenceContinuationState(statisticDataUnit, synCtx);
    }

    @Override
    public void handleOpenFlowSplittingEvent(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        this.startSpanOrBufferSequenceContinuationState(statisticDataUnit, synCtx);
    }

    @Override
    public void handleOpenFlowAggregateEvent(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        this.startSpanOrBufferSequenceContinuationState(statisticDataUnit, synCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSpanOrBufferSequenceContinuationState(StatisticDataUnit statisticDataUnit, MessageContext synCtx) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(synCtx);
        SpanStore spanStore = tracingScope.getSpanStore();
        synchronized (spanStore) {
            if (!this.isContinuationStateApplicable(statisticDataUnit)) {
                this.startSpan(statisticDataUnit, synCtx, tracingScope.getSpanStore());
            } else {
                this.bufferSequenceContinuationState(statisticDataUnit, tracingScope.getSpanStore());
            }
        }
    }

    private boolean isContinuationStateApplicable(StatisticDataUnit statisticDataUnit) {
        return statisticDataUnit.getComponentType() == ComponentType.SEQUENCE && (SequenceType.PROXY_INSEQ.toString().equals(statisticDataUnit.getComponentName()) || SequenceType.PROXY_OUTSEQ.toString().equals(statisticDataUnit.getComponentName()) || SequenceType.API_INSEQ.toString().equals(statisticDataUnit.getComponentName()) || SequenceType.API_OUTSEQ.toString().equals(statisticDataUnit.getComponentName()));
    }

    private void startSpan(StatisticDataUnit statisticDataUnit, MessageContext synCtx, SpanStore spanStore) {
        JaegerSpan span;
        JaegerSpanContext spanContext;
        SpanWrapper parentSpanWrapper = ParentResolver.resolveParent(statisticDataUnit, spanStore, synCtx);
        Span parentSpan = null;
        if (parentSpanWrapper != null) {
            parentSpan = parentSpanWrapper.getSpan();
        }
        HashMap tracerSpecificCarrier = new HashMap();
        Map headersMap = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        Object statusCode = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_SC");
        Object statusDescription = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_DESC");
        if (this.isOuterLevelSpan(statisticDataUnit, spanStore) && headersMap != null) {
            spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headersMap));
            span = this.tracer.buildSpan(statisticDataUnit.getComponentName()).asChildOf((SpanContext)spanContext).start();
        } else {
            span = this.tracer.buildSpan(statisticDataUnit.getComponentName()).asChildOf(parentSpan).start();
            spanContext = span.context();
        }
        if (spanContext != null) {
            this.tracer.inject((SpanContext)spanContext, Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(tracerSpecificCarrier));
        }
        if (headersMap != null) {
            headersMap.putAll(tracerSpecificCarrier);
            statisticDataUnit.setTransportHeaderMap(headersMap);
        }
        if (statusCode != null) {
            statisticDataUnit.setStatusCode(statusCode.toString());
        }
        if (statusDescription != null) {
            statisticDataUnit.setStatusDescription(statusDescription.toString());
        }
        if (statisticDataUnit.getComponentType() != null & statisticDataUnit.getComponentType() == ComponentType.ENDPOINT) {
            statisticDataUnit.setEndpoint(synCtx.getEndpoint(statisticDataUnit.getComponentName()));
        }
        String spanId = TracingUtils.extractId(statisticDataUnit);
        SpanWrapper spanWrapper = spanStore.addSpanWrapper(spanId, (Span)span, statisticDataUnit, parentSpanWrapper, synCtx);
        if (this.isOuterLevelSpan(statisticDataUnit, spanStore)) {
            spanStore.assignOuterLevelSpan(spanWrapper);
        }
    }

    private void bufferSequenceContinuationState(StatisticDataUnit statisticDataUnit, SpanStore spanStore) {
        ContinuationStateSequenceInfo continuationStateSequenceInfo = new ContinuationStateSequenceInfo(statisticDataUnit);
        spanStore.addContinuationStateSequenceInfo(continuationStateSequenceInfo);
    }

    private boolean isOuterLevelSpan(StatisticDataUnit statisticDataUnit, SpanStore spanStore) {
        return spanStore.getOuterLevelSpanWrapper() == null && (statisticDataUnit.getComponentType() == ComponentType.PROXYSERVICE || statisticDataUnit.getComponentType() == ComponentType.API);
    }

    @Override
    public void handleOpenFlowAsynchronousEvent(BasicStatisticDataUnit statisticDataUnit, MessageContext synCtx) {
    }

    @Override
    public void handleOpenContinuationEvents(BasicStatisticDataUnit statisticDataUnit, MessageContext synCtx) {
    }

    @Override
    public void handleCloseEntryEvent(BasicStatisticDataUnit basicStatisticDataUnit, MessageContext synCtx) {
        this.handleCloseEvent(basicStatisticDataUnit, synCtx);
    }

    @Override
    public void handleCloseFlowForcefully(BasicStatisticDataUnit basicStatisticDataUnit, MessageContext synCtx) {
        this.handleCloseEvent(basicStatisticDataUnit, synCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCloseEvent(BasicStatisticDataUnit basicStatisticDataUnit, MessageContext synCtx) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(synCtx);
        SpanStore spanStore = tracingScope.getSpanStore();
        synchronized (spanStore) {
            if (!this.isBufferedForContinuationState(basicStatisticDataUnit, tracingScope.getSpanStore())) {
                this.finishSpan(basicStatisticDataUnit, synCtx, tracingScope.getSpanStore(), tracingScope);
            }
        }
    }

    private boolean isBufferedForContinuationState(BasicStatisticDataUnit basicStatisticDataUnit, SpanStore spanStore) {
        return spanStore.hasContinuationStateSequenceInfoWithId(TracingUtils.extractId(basicStatisticDataUnit));
    }

    @Override
    public void handleTryEndFlow(BasicStatisticDataUnit basicStatisticDataUnit, MessageContext synCtx) {
    }

    private void finishSpan(BasicStatisticDataUnit basicStatisticDataUnit, MessageContext synCtx, SpanStore spanStore, TracingScope tracingScope) {
        String spanWrapperId = TracingUtils.extractId(basicStatisticDataUnit);
        SpanWrapper spanWrapper = spanStore.getSpanWrapper(spanWrapperId);
        if (spanWrapper != null && basicStatisticDataUnit instanceof StatisticDataUnit) {
            spanWrapper.setCloseEventStatisticDataUnit((StatisticDataUnit)basicStatisticDataUnit);
        }
        if (!Objects.equals(spanWrapper, spanStore.getOuterLevelSpanWrapper())) {
            spanStore.finishSpan(spanWrapper);
        } else if (tracingScope.isEventCollectionFinished(synCtx)) {
            this.cleanupContinuationStateSequences(spanStore);
            spanStore.finishSpan(spanWrapper);
            this.tracingScopeManager.cleanupTracingScope(tracingScope.getTracingScopeId());
        }
    }

    private void cleanupContinuationStateSequences(SpanStore spanStore) {
        if (!spanStore.getContinuationStateSequenceInfos().isEmpty()) {
            List<ContinuationStateSequenceInfo> continuationStateSequences = spanStore.getContinuationStateSequenceInfos();
            for (ContinuationStateSequenceInfo continuationStateSequence : continuationStateSequences) {
                this.finishSpanForContinuationStateSequence(continuationStateSequence, spanStore);
            }
            continuationStateSequences.clear();
        }
    }

    private void finishSpanForContinuationStateSequence(ContinuationStateSequenceInfo continuationStateSequenceInfo, SpanStore spanStore) {
        String spanWrapperId = continuationStateSequenceInfo.getSpanReferenceId();
        SpanWrapper spanWrapper = spanStore.getSpanWrapper(spanWrapperId);
        spanStore.finishSpan(spanWrapper);
    }

    @Override
    public void handleAddCallback(MessageContext messageContext, String callbackId) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(messageContext);
        tracingScope.addCallback();
    }

    @Override
    public void handleCallbackCompletionEvent(MessageContext oldMessageContext, String callbackId) {
        this.handleCallbackFinishEvent(oldMessageContext);
    }

    @Override
    public void handleUpdateParentsForCallback(MessageContext oldMessageContext, String callbackId) {
    }

    @Override
    public void handleReportCallbackHandlingCompletion(MessageContext synapseOutMsgCtx, String callbackId) {
        this.handleCallbackFinishEvent(synapseOutMsgCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallbackFinishEvent(MessageContext messageContext) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(messageContext);
        tracingScope.removeCallback();
        if (tracingScope.isEventCollectionFinished(messageContext)) {
            SpanStore spanStore = tracingScope.getSpanStore();
            synchronized (spanStore) {
                this.cleanupContinuationStateSequences(tracingScope.getSpanStore());
                SpanWrapper outerLevelSpanWrapper = tracingScope.getSpanStore().getOuterLevelSpanWrapper();
                tracingScope.getSpanStore().finishSpan(outerLevelSpanWrapper);
                this.tracingScopeManager.cleanupTracingScope(tracingScope.getTracingScopeId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStateStackInsertion(MessageContext synCtx, String seqName, SequenceType seqType) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(synCtx);
        SpanStore spanStore = tracingScope.getSpanStore();
        synchronized (spanStore) {
            ContinuationStateSequenceInfo continuationStateSequenceInfo = this.findContinuationStateSequenceInfo(seqType, tracingScope.getSpanStore(), false);
            if (continuationStateSequenceInfo != null) {
                StatisticDataUnit statisticDataUnit = continuationStateSequenceInfo.getStatisticDataUnit();
                continuationStateSequenceInfo.setSpanActive(true);
                this.startSpan(statisticDataUnit, synCtx, tracingScope.getSpanStore());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStateStackRemoval(ContinuationState continuationState, MessageContext synCtx) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(synCtx);
        SpanStore spanStore = tracingScope.getSpanStore();
        synchronized (spanStore) {
            ContinuationStateSequenceInfo continuationStateSequenceInfo;
            if (continuationState instanceof SeqContinuationState && (continuationStateSequenceInfo = this.findContinuationStateSequenceInfo(((SeqContinuationState)continuationState).getSeqType(), tracingScope.getSpanStore(), true)) != null) {
                continuationStateSequenceInfo.setSpanActive(false);
                this.finishSpanForContinuationStateSequence(continuationStateSequenceInfo, tracingScope.getSpanStore());
                tracingScope.getSpanStore().getContinuationStateSequenceInfos().remove(continuationStateSequenceInfo);
            }
        }
    }

    private ContinuationStateSequenceInfo findContinuationStateSequenceInfo(SequenceType seqType, SpanStore spanStore, boolean desiredSpanActiveState) {
        for (ContinuationStateSequenceInfo continuationStateSequenceInfo : spanStore.getContinuationStateSequenceInfos()) {
            if (!seqType.toString().equals(continuationStateSequenceInfo.getStatisticDataUnit().getComponentName()) || continuationStateSequenceInfo.isSpanActive() != desiredSpanActiveState) continue;
            return continuationStateSequenceInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStateStackClearance(MessageContext synCtx) {
        TracingScope tracingScope = this.tracingScopeManager.getTracingScope(synCtx);
        SpanStore spanStore = tracingScope.getSpanStore();
        synchronized (spanStore) {
            List<ContinuationStateSequenceInfo> stackedSequences = tracingScope.getSpanStore().getContinuationStateSequenceInfos();
            for (ContinuationStateSequenceInfo stackedSequence : stackedSequences) {
                this.finishSpanForContinuationStateSequence(stackedSequence, tracingScope.getSpanStore());
            }
            stackedSequences.clear();
        }
    }
}

