/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing.management;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.zipkin.ZipkinV2Reporter;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.OpenTracingManager;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.handling.span.JaegerSpanHandler;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.scoping.TracingScopeManager;

public class JaegerTracingManager
implements OpenTracingManager {
    private static final String USER_DEFINED_NAME = System.getenv("SERVICE_NAME");
    private static final String SERVICE_NAME = USER_DEFINED_NAME != null && !USER_DEFINED_NAME.isEmpty() ? USER_DEFINED_NAME : "WSO2-SYNAPSE";
    private JaegerTracer tracer;
    private JaegerSpanHandler handler;

    public JaegerTracingManager(Configuration.SamplerConfiguration sampler, Configuration.ReporterConfiguration reporter) {
        this.initializeTracer(sampler, reporter);
        this.resolveHandler();
    }

    public JaegerTracingManager(ConstSampler sampler, ZipkinV2Reporter reporter) {
        this.initializeTracer(sampler, reporter);
        this.resolveHandler();
    }

    private void initializeTracer(Configuration.SamplerConfiguration sampler, Configuration.ReporterConfiguration reporterConf) {
        String serviceName = JaegerTracingManager.getServiceName();
        this.tracer = new Configuration(serviceName).withSampler(sampler).withReporter(reporterConf).getTracer();
    }

    private void initializeTracer(ConstSampler sampler, ZipkinV2Reporter reporter) {
        String serviceName = JaegerTracingManager.getServiceName();
        this.tracer = new JaegerTracer.Builder(serviceName).withSampler((Sampler)sampler).withReporter((Reporter)reporter).build();
    }

    @Override
    public void resolveHandler() {
        this.handler = new JaegerSpanHandler(this.tracer, new TracingScopeManager());
    }

    @Override
    public JaegerSpanHandler getHandler() {
        return this.handler;
    }

    private static String getServiceName() {
        return SERVICE_NAME;
    }
}

