/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.opentracing;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.samplers.ConstSampler;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.JaegerTracingManager;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.OpenTracingManager;
import org.apache.synapse.aspects.flow.statistics.opentracing.management.helpers.zipkin.ZipkinV2ReporterFactory;

public class OpenTracingManagerHolder {
    private static boolean isCollectingPayloads;
    private static boolean isCollectingProperties;
    private static OpenTracingManager openTracingManager;

    private OpenTracingManagerHolder() {
    }

    public static void loadJaegerConfigurations(String samplerManagerHostPort, String senderAgentHost, int senderAgentPort, boolean logSpans, int reporterMaxQueueSize, int reporterFlushInterval) {
        Configuration.SamplerConfiguration sampler = new Configuration.SamplerConfiguration().withType("const").withParam((Number)1).withManagerHostPort(samplerManagerHostPort);
        Configuration.SenderConfiguration sender = new Configuration.SenderConfiguration().withAgentHost(senderAgentHost).withAgentPort(Integer.valueOf(senderAgentPort));
        Configuration.ReporterConfiguration reporter = new Configuration.ReporterConfiguration().withLogSpans(Boolean.valueOf(logSpans)).withSender(sender).withMaxQueueSize(Integer.valueOf(reporterMaxQueueSize)).withFlushInterval(Integer.valueOf(reporterFlushInterval));
        openTracingManager = new JaegerTracingManager(sampler, reporter);
    }

    public static void loadZipkinConfigurations(String zipkinBackendURL) {
        ZipkinV2ReporterFactory factory = new ZipkinV2ReporterFactory(zipkinBackendURL);
        ConstSampler sampler = new ConstSampler(true);
        openTracingManager = new JaegerTracingManager(sampler, factory.getReporter());
    }

    public static void setCollectingFlags(boolean collectPayloads, boolean collectProperties) {
        isCollectingPayloads = collectPayloads;
        isCollectingProperties = collectProperties;
    }

    public static boolean isCollectingPayloads() {
        return isCollectingPayloads;
    }

    public static boolean isCollectingProperties() {
        return isCollectingProperties;
    }

    public static OpenTracingManager getOpenTracingManager() {
        return openTracingManager;
    }
}

