/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.data.raw;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.endpoints.Endpoint;

public class StatisticsLog {
    private int parentIndex;
    private int noOfFaults = 0;
    private int numberOpenTimes = 1;
    private int currentIndex;
    private long startTime = -1L;
    private long endTime = 0L;
    private boolean isFlowContinuable;
    private boolean isFlowSplittingMediator;
    private boolean isFlowAggregateMediator;
    private String componentName;
    private String messageFlowId;
    private String beforePayload;
    private String afterPayload;
    private String componentId;
    private String propertyValue;
    private Integer hashCode;
    private List<Integer> children = new LinkedList<Integer>();
    private Map<String, Object> contextPropertyMap;
    private Map<String, Object> transportPropertyMap;
    private ComponentType componentType;
    private int immediateParent;
    private boolean isTracingEnabled;
    private Endpoint endpoint;
    private Map<String, Object> transportHeaderMap;
    private String statusCode;
    private String statusDescription;

    public StatisticsLog(StatisticDataUnit statisticDataUnit) {
        this.parentIndex = statisticDataUnit.getParentIndex();
        this.currentIndex = statisticDataUnit.getCurrentIndex();
        this.startTime = statisticDataUnit.getTime();
        this.isFlowContinuable = statisticDataUnit.isFlowContinuableMediator();
        this.isFlowSplittingMediator = statisticDataUnit.isFlowSplittingMediator();
        this.isFlowAggregateMediator = statisticDataUnit.isFlowAggregateMediator();
        this.componentName = statisticDataUnit.getComponentName();
        this.messageFlowId = statisticDataUnit.getStatisticId();
        this.beforePayload = statisticDataUnit.getPayload();
        this.contextPropertyMap = statisticDataUnit.getContextPropertyMap();
        this.transportPropertyMap = statisticDataUnit.getTransportPropertyMap();
        this.componentType = statisticDataUnit.getComponentType();
        this.hashCode = statisticDataUnit.getHashCode();
        this.propertyValue = statisticDataUnit.getPropertyValue();
        this.componentId = statisticDataUnit.getComponentId() == null ? "HashCodeNullComponent" : statisticDataUnit.getComponentId();
        this.isTracingEnabled = statisticDataUnit.isTracingEnabled();
        this.endpoint = statisticDataUnit.getEndpoint();
        this.transportHeaderMap = statisticDataUnit.getTransportHeaderMap();
        this.statusCode = statisticDataUnit.getStatusCode();
        this.statusDescription = statisticDataUnit.getStatusDescription();
    }

    public StatisticsLog(ComponentType componentType, String componentName, int parentIndex) {
        this.componentType = componentType;
        this.componentName = componentName;
        this.parentIndex = parentIndex;
    }

    public void decrementParentLevel() {
        --this.parentIndex;
    }

    public void decrementChildren() {
        if (this.children.size() > 0) {
            for (Integer child : this.children) {
                Integer n = child - 1;
            }
        }
    }

    public String getComponentTypeToString() {
        switch (this.componentType) {
            case PROXYSERVICE: {
                return "Proxy Service";
            }
            case ENDPOINT: {
                return "Endpoint";
            }
            case INBOUNDENDPOINT: {
                return "Inbound EndPoint";
            }
            case SEQUENCE: {
                return "Sequence";
            }
            case MEDIATOR: {
                return "Mediator";
            }
            case API: {
                return "API";
            }
            case RESOURCE: {
                return "API Resource";
            }
        }
        return "Other Type";
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getNoOfFaults() {
        return this.noOfFaults;
    }

    public void incrementNoOfFaults() {
        ++this.noOfFaults;
    }

    public void setChildren(Integer childrenIndex) {
        this.children.add(childrenIndex);
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public String getMessageFlowId() {
        return this.messageFlowId;
    }

    public void setMessageFlowId(String messageFlowId) {
        this.messageFlowId = messageFlowId;
    }

    public String getBeforePayload() {
        return this.beforePayload;
    }

    public void setBeforePayload(String beforePayload) {
        this.beforePayload = beforePayload;
    }

    public Map<String, Object> getContextPropertyMap() {
        return this.contextPropertyMap;
    }

    public void setAfterPayload(String afterPayload) {
        this.afterPayload = afterPayload;
    }

    public String getAfterPayload() {
        return this.afterPayload;
    }

    public boolean isOpenLog() {
        return this.numberOpenTimes > 0;
    }

    public void incrementOpenTimes() {
        ++this.numberOpenTimes;
    }

    public void decrementOpenTimes() {
        --this.numberOpenTimes;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public Map<String, Object> getTransportPropertyMap() {
        return this.transportPropertyMap;
    }

    public void setChildren(List<Integer> children) {
        this.children = children;
    }

    public boolean isFlowContinuable() {
        return this.isFlowContinuable;
    }

    public boolean isFlowSplittingMediator() {
        return this.isFlowSplittingMediator;
    }

    public boolean isFlowAggregateMediator() {
        return this.isFlowAggregateMediator;
    }

    public int getImmediateParent() {
        return this.immediateParent;
    }

    public void setImmediateParent(int immediateParent) {
        this.immediateParent = immediateParent;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Integer getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(Integer hashCode) {
        this.hashCode = hashCode;
    }

    public boolean isTracingEnabled() {
        return this.isTracingEnabled;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.isTracingEnabled = tracingEnabled;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getTransportHeaderMap() {
        return this.transportHeaderMap;
    }

    public void setTransportHeaderMap(Map<String, Object> transportHeaderMap) {
        this.transportHeaderMap = transportHeaderMap;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }
}

