/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.log.StatisticsReportingEvent;
import org.apache.synapse.aspects.flow.statistics.log.StatisticsReportingEventHolder;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.util.MediationFlowController;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapsePropertiesLoader;

public abstract class RuntimeStatisticCollector {
    private static final Log log = LogFactory.getLog(RuntimeStatisticCollector.class);
    private static boolean isStatisticsEnabled;
    private static boolean isOpenTracingEnabled;
    private static boolean isMediationFlowStatisticsEnabled;
    private static boolean isCollectingPayloads;
    private static boolean isCollectingProperties;
    private static boolean isCollectingAllStatistics;
    public static long eventExpireTime;

    public static void init() {
        isMediationFlowStatisticsEnabled = SynapsePropertiesLoader.getBooleanProperty("mediation.flow.statistics.enable", false);
        isOpenTracingEnabled = SynapsePropertiesLoader.getBooleanProperty("opentracing.enable", false);
        boolean bl = isStatisticsEnabled = isMediationFlowStatisticsEnabled || isOpenTracingEnabled;
        if (isStatisticsEnabled) {
            if (log.isDebugEnabled()) {
                if (isMediationFlowStatisticsEnabled) {
                    log.debug((Object)"Mediation statistics collection is enabled.");
                } else if (isOpenTracingEnabled) {
                    log.debug((Object)"OpenTracing is enabled.");
                }
            }
            Long eventConsumerTime = Long.parseLong(SynapsePropertiesLoader.getPropertyValue("mediation.flow.statistics.event.consume.interval", "1000"));
            isCollectingPayloads = SynapsePropertiesLoader.getBooleanProperty("mediation.flow.statistics.tracer.collect.payloads", false);
            if (!isCollectingPayloads && log.isDebugEnabled()) {
                log.debug((Object)"Payload collecting is not enabled in 'synapse.properties' file.");
            }
            if (!(isCollectingProperties = SynapsePropertiesLoader.getBooleanProperty("mediation.flow.statistics.tracer.collect.properties", false).booleanValue()) && log.isDebugEnabled()) {
                log.debug((Object)"Property collecting is not enabled in 'synapse.properties' file.");
            }
            isCollectingAllStatistics = SynapsePropertiesLoader.getBooleanProperty("mediation.flow.statistics.collect.all", false);
            eventExpireTime = SynapseConfigUtils.getGlobalTimeoutInterval() + SynapseConfigUtils.getTimeoutHandlerInterval() + eventConsumerTime;
            log.info((Object)("Statistics Entry Expiration time set to " + eventExpireTime + " milliseconds"));
            new MediationFlowController();
            if (isOpenTracingEnabled) {
                boolean isZipkinEnabled = SynapsePropertiesLoader.getBooleanProperty("opentracing.zipkin.enable", false);
                if (!isZipkinEnabled) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Jaeger client is enabled for traces");
                    }
                    RuntimeStatisticCollector.initOpenTracingJaegerClient(isCollectingPayloads, isCollectingProperties);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Zipkin client is enabled for traces");
                    }
                    RuntimeStatisticCollector.initOpenTracingZipkinClient(isCollectingPayloads, isCollectingProperties);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Statistics is not enabled in 'synapse.properties' file.");
        }
    }

    private static void initOpenTracingJaegerClient(boolean isCollectingPayloads, boolean isCollectingProperties) {
        String DEFAULT_JAEGER_SAMPLER_MANAGER_HOST = "localhost";
        String DEFAULT_JAEGER_SAMPLER_MANAGER_PORT = "5778";
        String DEFAULT_JAEGER_SENDER_AGENT_HOST = "localhost";
        String DEFAULT_JAEGER_SENDER_AGENT_PORT = "6831";
        String DEFAULT_JAEGER_REPORTER_MAX_QUEUE_SIZE = "100";
        String DEFAULT_JAEGER_REPORTER_FLUSH_INTERVAL = "10000";
        String samplerManagerHost = SynapsePropertiesLoader.getPropertyValue("jaeger.sampler.manager.host", "localhost");
        String samplerManagerPort = SynapsePropertiesLoader.getPropertyValue("jaeger.sampler.manager.port", "5778");
        String samplerManagerHostPort = samplerManagerHost + ":" + samplerManagerPort;
        String senderAgentHost = SynapsePropertiesLoader.getPropertyValue("jaeger.sender.agent.host", "localhost");
        String senderAgentPort = SynapsePropertiesLoader.getPropertyValue("jaeger.sender.agent.port", "6831");
        String reporterMaxQueueSize = SynapsePropertiesLoader.getPropertyValue("jaeger.reporter.max.queue.size", "100");
        String reporterFlushInterval = SynapsePropertiesLoader.getPropertyValue("jaeger.reporter.flush.interval", "10000");
        int senderAgentPortInt = Integer.parseInt(senderAgentPort);
        boolean logSpans = SynapsePropertiesLoader.getBooleanProperty("jaeger.reporter.log.spans", false);
        int reporterMaxQueueSizeInt = Integer.parseInt(reporterMaxQueueSize);
        int reporterFlushIntervalInt = Integer.parseInt(reporterFlushInterval);
        OpenTracingManagerHolder.loadJaegerConfigurations(samplerManagerHostPort, senderAgentHost, senderAgentPortInt, logSpans, reporterMaxQueueSizeInt, reporterFlushIntervalInt);
        OpenTracingManagerHolder.setCollectingFlags(isCollectingPayloads, isCollectingProperties);
    }

    private static void initOpenTracingZipkinClient(boolean isCollectingPayloads, boolean isCollectingProperties) {
        String DEFAULT_ZIPKIN_BACKEND_URL = "http://localhost:9411/api/v2/spans";
        String zipkinBackendURL = SynapsePropertiesLoader.getPropertyValue("opentracing.zipkin.backend.url", "http://localhost:9411/api/v2/spans");
        OpenTracingManagerHolder.loadZipkinConfigurations(zipkinBackendURL);
        OpenTracingManagerHolder.setCollectingFlags(isCollectingPayloads, isCollectingProperties);
    }

    protected static void setStatisticsTraceId(MessageContext msgCtx) {
        if (msgCtx.getProperty("mediation.flow.statistics.statistic.id") == null && msgCtx.getMessageID() != null) {
            msgCtx.setProperty("mediation.flow.statistics.statistic.id", msgCtx.getMessageID().replace(':', '_'));
        } else if (msgCtx.getMessageID() == null) {
            log.error((Object)"Message ID is null");
        }
    }

    public static boolean shouldReportStatistic(MessageContext messageContext) {
        if (!isStatisticsEnabled) {
            return false;
        }
        Boolean isStatCollected = (Boolean)messageContext.getProperty("mediation.flow.statistics.collected");
        Object statID = messageContext.getProperty("mediation.flow.statistics.statistic.id");
        return statID != null && isStatCollected != null && isStatCollected != false;
    }

    public static boolean isStatisticsEnabled() {
        return isStatisticsEnabled;
    }

    public static boolean isOpenTracingEnabled() {
        return isOpenTracingEnabled;
    }

    public static boolean isMediationFlowStatisticsEnabled() {
        return isMediationFlowStatisticsEnabled;
    }

    public static boolean isCollectingPayloads() {
        return isStatisticsEnabled && isCollectingPayloads;
    }

    public static boolean isCollectingProperties() {
        return isStatisticsEnabled && isCollectingProperties;
    }

    public static boolean isCollectingAllStatistics() {
        return isStatisticsEnabled && isCollectingAllStatistics;
    }

    public static void setCollectingAllStatistics(boolean state) {
        isCollectingAllStatistics = state;
        log.info((Object)("Collecting statistics for all artifacts state changed to: " + state));
    }

    protected static void addEventAndIncrementCount(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        if (eventHolder.isEvenCollectionFinished()) {
            RuntimeStatisticCollector.handleError(eventHolder, event);
            return;
        }
        eventHolder.addEvent(event);
        eventHolder.countHolder.incrementStatCount();
    }

    protected static void addEventAndDecrementCount(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        if (eventHolder.isEvenCollectionFinished()) {
            RuntimeStatisticCollector.handleError(eventHolder, event);
            return;
        }
        eventHolder.addEvent(event);
        if (eventHolder.countHolder.decrementAndGetStatCount() <= 0 && eventHolder.countHolder.getCallBackCount() <= 0) {
            eventHolder.setEvenCollectionFinished(true);
            messageContext.getEnvironment().getMessageDataStore().enqueue(eventHolder);
        }
    }

    protected static void addEventAndIncrementCallbackCount(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        if (eventHolder.isEvenCollectionFinished()) {
            RuntimeStatisticCollector.handleError(eventHolder, event);
            return;
        }
        eventHolder.addEvent(event);
        eventHolder.countHolder.incrementCallBackCount();
    }

    protected static void addEventAndDecrementCallbackCount(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        if (eventHolder.isEvenCollectionFinished()) {
            RuntimeStatisticCollector.handleError(eventHolder, event);
            return;
        }
        eventHolder.addEvent(event);
        if (eventHolder.countHolder.decrementAndGetCallbackCount() <= 0 && eventHolder.countHolder.getStatCount() <= 0) {
            eventHolder.setEvenCollectionFinished(true);
            messageContext.getEnvironment().getMessageDataStore().enqueue(eventHolder);
        }
    }

    protected static void addEvent(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        if (eventHolder.isEvenCollectionFinished()) {
            RuntimeStatisticCollector.handleError(eventHolder, event);
            return;
        }
        eventHolder.addEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addEventAndCloseFlow(MessageContext messageContext, StatisticsReportingEvent event) {
        StatisticsReportingEventHolder eventHolder = (StatisticsReportingEventHolder)messageContext.getProperty("STATISTIC_COLLECTOR");
        if (eventHolder == null) {
            eventHolder = new StatisticsReportingEventHolder();
            eventHolder.setPublishMediationFlowStatistics(isMediationFlowStatisticsEnabled);
            messageContext.setProperty("STATISTIC_COLLECTOR", eventHolder);
        }
        StatisticsReportingEventHolder statisticsReportingEventHolder = eventHolder;
        synchronized (statisticsReportingEventHolder) {
            if (eventHolder.isEvenCollectionFinished()) {
                RuntimeStatisticCollector.handleError(eventHolder, event);
                return;
            }
            eventHolder.addEvent(event);
            eventHolder.setEvenCollectionFinished(true);
            eventHolder.setMessageFlowError(true);
            messageContext.getEnvironment().getMessageDataStore().enqueue(eventHolder);
        }
    }

    private static void handleError(StatisticsReportingEventHolder eventHolder, StatisticsReportingEvent event) {
        if (eventHolder.isMessageFlowError()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message flow error happened, dropping event - " + event.getDataUnit().getStatisticId()));
            }
            return;
        }
        log.warn((Object)("Events occur after event collection is finished, event - " + event.getDataUnit().getStatisticId()));
    }
}

