/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.BasicStatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.log.templates.AsynchronousExecutionEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.ParentReopenEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.StatisticsOpenEvent;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.util.StatisticDataCollectionHelper;

public class OpenEventCollector
extends RuntimeStatisticCollector {
    private static final Log log = LogFactory.getLog(OpenEventCollector.class);

    public static Integer reportEntryEvent(MessageContext messageContext, String componentName, AspectConfiguration aspectConfiguration, ComponentType componentType) {
        boolean isCollectingStatistics;
        boolean bl = isCollectingStatistics = aspectConfiguration != null && aspectConfiguration.isStatisticsEnable();
        if (!isCollectingStatistics) {
            isCollectingStatistics = isCollectingStatistics || RuntimeStatisticCollector.isCollectingAllStatistics();
        }
        boolean isCollectingTracing = false;
        if (OpenEventCollector.isCollectingProperties() || OpenEventCollector.isCollectingPayloads()) {
            isCollectingTracing = aspectConfiguration != null && aspectConfiguration.isTracingEnabled();
        }
        Boolean isFlowStatisticEnabled = (Boolean)messageContext.getProperty("mediation.flow.statistics.collected");
        if (isCollectingStatistics) {
            messageContext.setProperty("mediation.flow.statistics.collected", true);
            OpenEventCollector.setStatisticsTraceId(messageContext);
            if (isCollectingTracing) {
                messageContext.setProperty("mediation.flow.trace.collected", true);
            }
        } else if (isFlowStatisticEnabled == null) {
            messageContext.setProperty("mediation.flow.statistics.collected", false);
        }
        Boolean isTracingEnabled = (Boolean)messageContext.getProperty("mediation.flow.trace.collected");
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            statisticDataUnit.setComponentName(componentName);
            statisticDataUnit.setComponentType(componentType);
            statisticDataUnit.setTracingEnabled(isCollectingTracing);
            statisticDataUnit.setSynapseEnvironment(messageContext.getEnvironment());
            statisticDataUnit.setCurrentIndex(StatisticDataCollectionHelper.getFlowPosition(messageContext));
            if (aspectConfiguration != null) {
                statisticDataUnit.setComponentId(aspectConfiguration.getUniqueId());
                statisticDataUnit.setHashCode(aspectConfiguration.getHashCode());
            }
            int parentIndex = StatisticDataCollectionHelper.getParentFlowPosition(messageContext, statisticDataUnit.getCurrentIndex());
            statisticDataUnit.setParentIndex(parentIndex);
            if (statisticDataUnit.getComponentType() != ComponentType.ENDPOINT) {
                statisticDataUnit.setFlowContinuableMediator(true);
            }
            if (aspectConfiguration != null) {
                statisticDataUnit.setIsIndividualStatisticCollected(isCollectingStatistics);
            }
            StatisticDataCollectionHelper.collectData(messageContext, true, isTracingEnabled, statisticDataUnit);
            StatisticsOpenEvent openEvent = new StatisticsOpenEvent(statisticDataUnit);
            OpenEventCollector.addEventAndIncrementCount(messageContext, openEvent);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenEntryEvent(statisticDataUnit, messageContext);
            }
            return statisticDataUnit.getCurrentIndex();
        }
        return null;
    }

    public static Integer reportChildEntryEvent(MessageContext messageContext, String componentName, ComponentType componentType, AspectConfiguration aspectConfiguration, boolean isContentAltering) {
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            OpenEventCollector.reportMediatorStatistics(messageContext, componentName, componentType, isContentAltering, statisticDataUnit, aspectConfiguration);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenChildEntryEvent(statisticDataUnit, messageContext);
            }
            return statisticDataUnit.getCurrentIndex();
        }
        return null;
    }

    public static Integer reportFlowContinuableEvent(MessageContext messageContext, String componentName, ComponentType componentType, AspectConfiguration aspectConfiguration, boolean isContentAltering) {
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            statisticDataUnit.setFlowContinuableMediator(true);
            OpenEventCollector.reportMediatorStatistics(messageContext, componentName, componentType, isContentAltering, statisticDataUnit, aspectConfiguration);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenFlowContinuableEvent(statisticDataUnit, messageContext);
            }
            return statisticDataUnit.getCurrentIndex();
        }
        return null;
    }

    public static Integer reportFlowSplittingEvent(MessageContext messageContext, String componentName, ComponentType componentType, AspectConfiguration aspectConfiguration, boolean isContentAltering) {
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            statisticDataUnit.setFlowContinuableMediator(true);
            statisticDataUnit.setFlowSplittingMediator(true);
            OpenEventCollector.reportMediatorStatistics(messageContext, componentName, componentType, isContentAltering, statisticDataUnit, aspectConfiguration);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenFlowSplittingEvent(statisticDataUnit, messageContext);
            }
            return statisticDataUnit.getCurrentIndex();
        }
        return null;
    }

    public static Integer reportFlowAggregateEvent(MessageContext messageContext, String componentName, ComponentType componentType, AspectConfiguration aspectConfiguration, boolean isContentAltering) {
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            statisticDataUnit.setFlowContinuableMediator(true);
            statisticDataUnit.setFlowAggregateMediator(true);
            OpenEventCollector.reportMediatorStatistics(messageContext, componentName, componentType, isContentAltering, statisticDataUnit, aspectConfiguration);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenFlowAggregateEvent(statisticDataUnit, messageContext);
            }
            return statisticDataUnit.getCurrentIndex();
        }
        return null;
    }

    public static void reportFlowAsynchronousEvent(MessageContext messageContext) {
        if (OpenEventCollector.shouldReportStatistic(messageContext)) {
            BasicStatisticDataUnit dataUnit = new BasicStatisticDataUnit();
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(messageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(messageContext, null));
            AsynchronousExecutionEvent asynchronousExecutionEvent = new AsynchronousExecutionEvent(dataUnit);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenFlowAsynchronousEvent(dataUnit, messageContext);
            }
            OpenEventCollector.addEventAndIncrementCount(messageContext, asynchronousExecutionEvent);
        }
    }

    private static void reportMediatorStatistics(MessageContext messageContext, String componentName, ComponentType componentType, boolean isContentAltering, StatisticDataUnit statisticDataUnit, AspectConfiguration aspectConfiguration) {
        Boolean isCollectingTracing = (Boolean)messageContext.getProperty("mediation.flow.trace.collected");
        statisticDataUnit.setComponentName(componentName);
        statisticDataUnit.setComponentType(componentType);
        statisticDataUnit.setCurrentIndex(StatisticDataCollectionHelper.getFlowPosition(messageContext));
        if (aspectConfiguration != null) {
            statisticDataUnit.setComponentId(aspectConfiguration.getUniqueId());
            statisticDataUnit.setHashCode(aspectConfiguration.getHashCode());
        }
        int parentIndex = StatisticDataCollectionHelper.getParentFlowPosition(messageContext, statisticDataUnit.getCurrentIndex());
        statisticDataUnit.setParentIndex(parentIndex);
        StatisticDataCollectionHelper.collectData(messageContext, isContentAltering, isCollectingTracing, statisticDataUnit);
        StatisticsOpenEvent openEvent = new StatisticsOpenEvent(statisticDataUnit);
        OpenEventCollector.addEventAndIncrementCount(messageContext, openEvent);
    }

    public static void openContinuationEvents(MessageContext synCtx) {
        if (OpenEventCollector.shouldReportStatistic(synCtx)) {
            BasicStatisticDataUnit basicStatisticDataUnit = new BasicStatisticDataUnit();
            basicStatisticDataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(synCtx, null));
            basicStatisticDataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(synCtx));
            ParentReopenEvent parentReopenEvent = new ParentReopenEvent(basicStatisticDataUnit);
            OpenEventCollector.addEvent(synCtx, parentReopenEvent);
            if (OpenEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleOpenContinuationEvents(basicStatisticDataUnit, synCtx);
            }
        }
    }
}

