/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.BasicStatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.log.templates.FaultEvent;
import org.apache.synapse.aspects.flow.statistics.util.StatisticDataCollectionHelper;

public class FaultStatisticCollector
extends RuntimeStatisticCollector {
    private static final Log log = LogFactory.getLog(FaultStatisticCollector.class);

    public static void reportFault(MessageContext messageContext) {
        boolean isFaultCreated;
        if (FaultStatisticCollector.shouldReportStatistic(messageContext) && !(isFaultCreated = FaultStatisticCollector.isFaultAlreadyReported(messageContext))) {
            BasicStatisticDataUnit dataUnit = new BasicStatisticDataUnit();
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(messageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(messageContext, null));
            FaultEvent faultEvent = new FaultEvent(dataUnit);
            FaultStatisticCollector.addEventAndIncrementCount(messageContext, faultEvent);
        }
    }

    private static boolean isFaultAlreadyReported(MessageContext synCtx) {
        Boolean faultReported = (Boolean)synCtx.getProperty("mediation.flow.statistics.fault.reported");
        return faultReported != null && faultReported != false;
    }
}

