/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.BasicStatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.data.raw.StatisticDataUnit;
import org.apache.synapse.aspects.flow.statistics.log.templates.EndFlowEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.StatisticsCloseEvent;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.util.StatisticDataCollectionHelper;

public class CloseEventCollector
extends RuntimeStatisticCollector {
    private static final Log log = LogFactory.getLog(CloseEventCollector.class);

    public static void closeEntryEvent(MessageContext messageContext, String componentName, ComponentType componentType, Integer currentIndex, boolean isContentAltering) {
        CloseEventCollector.closeEntryEvent(messageContext, componentName, componentType, currentIndex, isContentAltering, null);
    }

    public static void closeEntryEvent(MessageContext messageContext, String componentName, ComponentType componentType, Integer currentIndex, boolean isContentAltering, String propertyValue) {
        if (CloseEventCollector.shouldReportStatistic(messageContext)) {
            Boolean isCollectingTracing = (Boolean)messageContext.getProperty("mediation.flow.trace.collected");
            StatisticDataUnit statisticDataUnit = new StatisticDataUnit();
            if (propertyValue != null) {
                statisticDataUnit.setPropertyValue(propertyValue);
            }
            statisticDataUnit.setComponentName(componentName);
            statisticDataUnit.setComponentType(componentType);
            if (currentIndex == null) {
                statisticDataUnit.setShouldTrackParent(true);
                statisticDataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(messageContext, null));
                statisticDataUnit.setContinuationCall(true);
            } else {
                statisticDataUnit.setCurrentIndex(currentIndex);
            }
            StatisticDataCollectionHelper.collectData(messageContext, isContentAltering, isCollectingTracing, statisticDataUnit);
            StatisticsCloseEvent closeEvent = new StatisticsCloseEvent(statisticDataUnit);
            if (currentIndex == null) {
                CloseEventCollector.addEvent(messageContext, closeEvent);
            } else {
                CloseEventCollector.addEventAndDecrementCount(messageContext, closeEvent);
            }
            if (CloseEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleCloseEntryEvent(statisticDataUnit, messageContext);
            }
        }
    }

    public static void closeFlowForcefully(MessageContext messageContext, boolean error) {
        if (CloseEventCollector.shouldReportStatistic(messageContext)) {
            BasicStatisticDataUnit dataUnit = new BasicStatisticDataUnit();
            dataUnit.setTime(System.currentTimeMillis());
            dataUnit.setSynapseEnvironment(messageContext.getEnvironment());
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(messageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(messageContext, null));
            EndFlowEvent endFlowEvent = new EndFlowEvent(dataUnit);
            if (!error) {
                CloseEventCollector.addEventAndDecrementCount(messageContext, endFlowEvent);
            } else {
                CloseEventCollector.addEventAndCloseFlow(messageContext, endFlowEvent);
            }
            if (CloseEventCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleCloseFlowForcefully(dataUnit, messageContext);
            }
        }
    }

    public static void tryEndFlow(MessageContext messageContext, String componentName, ComponentType componentType, Integer currentIndex, boolean isContentAltering) {
        if (CloseEventCollector.shouldReportStatistic(messageContext)) {
            CloseEventCollector.closeEntryEvent(messageContext, componentName, componentType, currentIndex, isContentAltering);
        }
    }
}

