/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics.collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.raw.CallbackDataUnit;
import org.apache.synapse.aspects.flow.statistics.log.templates.CallbackCompletionEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.CallbackHandledEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.CallbackReceivedEvent;
import org.apache.synapse.aspects.flow.statistics.log.templates.CallbackSentEvent;
import org.apache.synapse.aspects.flow.statistics.opentracing.OpenTracingManagerHolder;
import org.apache.synapse.aspects.flow.statistics.util.StatisticDataCollectionHelper;

public class CallbackStatisticCollector
extends RuntimeStatisticCollector {
    private static final Log log = LogFactory.getLog(CallbackStatisticCollector.class);

    public static void addCallback(MessageContext messageContext, String callbackId) {
        if (CallbackStatisticCollector.shouldReportStatistic(messageContext)) {
            CallbackDataUnit dataUnit = new CallbackDataUnit();
            dataUnit.setCallbackId(callbackId);
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(messageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(messageContext, null));
            CallbackSentEvent callbackSentEvent = new CallbackSentEvent(dataUnit);
            CallbackStatisticCollector.addEventAndIncrementCallbackCount(messageContext, callbackSentEvent);
            if (CallbackStatisticCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleAddCallback(messageContext, callbackId);
            }
        }
    }

    public static void callbackCompletionEvent(MessageContext oldMessageContext, String callbackId) {
        if (CallbackStatisticCollector.shouldReportStatistic(oldMessageContext)) {
            CallbackDataUnit dataUnit = new CallbackDataUnit();
            dataUnit.setCallbackId(callbackId);
            dataUnit.setTime(System.currentTimeMillis());
            dataUnit.setSynapseEnvironment(oldMessageContext.getEnvironment());
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(oldMessageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(oldMessageContext, null));
            dataUnit.setIsOutOnlyFlow(StatisticDataCollectionHelper.isOutOnlyFlow(oldMessageContext));
            CallbackCompletionEvent callbackCompletionEvent = new CallbackCompletionEvent(dataUnit);
            CallbackStatisticCollector.addEventAndDecrementCallbackCount(oldMessageContext, callbackCompletionEvent);
            if (CallbackStatisticCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleCallbackCompletionEvent(oldMessageContext, callbackId);
            }
        }
    }

    public static void updateParentsForCallback(MessageContext oldMessageContext, String callbackId) {
        if (CallbackStatisticCollector.shouldReportStatistic(oldMessageContext)) {
            CallbackDataUnit dataUnit = new CallbackDataUnit();
            dataUnit.setCallbackId(callbackId);
            dataUnit.setTime(System.currentTimeMillis());
            dataUnit.setSynapseEnvironment(oldMessageContext.getEnvironment());
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(oldMessageContext));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(oldMessageContext, null));
            dataUnit.setIsOutOnlyFlow(StatisticDataCollectionHelper.isOutOnlyFlow(oldMessageContext));
            CallbackReceivedEvent callbackReceivedEvent = new CallbackReceivedEvent(dataUnit);
            CallbackStatisticCollector.addEvent(oldMessageContext, callbackReceivedEvent);
            if (CallbackStatisticCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleUpdateParentsForCallback(oldMessageContext, callbackId);
            }
        }
    }

    public static void reportCallbackHandlingCompletion(MessageContext synapseOutMsgCtx, String callbackId) {
        if (CallbackStatisticCollector.shouldReportStatistic(synapseOutMsgCtx)) {
            CallbackDataUnit dataUnit = new CallbackDataUnit();
            dataUnit.setCallbackId(callbackId);
            dataUnit.setTime(System.currentTimeMillis());
            dataUnit.setSynapseEnvironment(synapseOutMsgCtx.getEnvironment());
            dataUnit.setStatisticId(StatisticDataCollectionHelper.getStatisticTraceId(synapseOutMsgCtx));
            dataUnit.setCurrentIndex(StatisticDataCollectionHelper.getParentFlowPosition(synapseOutMsgCtx, null));
            CallbackHandledEvent callbackHandledEvent = new CallbackHandledEvent(dataUnit);
            CallbackStatisticCollector.addEventAndDecrementCallbackCount(synapseOutMsgCtx, callbackHandledEvent);
            if (CallbackStatisticCollector.isOpenTracingEnabled()) {
                OpenTracingManagerHolder.getOpenTracingManager().getHandler().handleReportCallbackHandlingCompletion(synapseOutMsgCtx, callbackId);
            }
        }
    }
}

