/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.flow.statistics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.aspects.flow.statistics.opentracing.stores.ArtifactHolderStore;
import org.apache.synapse.aspects.flow.statistics.structuring.StructuringArtifact;
import org.apache.synapse.aspects.flow.statistics.structuring.StructuringElement;
import org.apache.synapse.config.SynapseConfiguration;

public class StatisticIdentityGenerator {
    private static Log log = LogFactory.getLog(StatisticIdentityGenerator.class);
    private static SynapseConfiguration synapseConfiguration;

    public static void conclude(ArtifactHolder holder) {
        if (holder.getList().size() > 0) {
            String artifactName = holder.getParent();
            StructuringArtifact structuringArtifact = new StructuringArtifact(holder.getHashCode(), artifactName, holder.getList());
            if (synapseConfiguration != null) {
                synapseConfiguration.getCompletedStructureStore().putCompletedStatisticEntry(structuringArtifact);
            }
        }
    }

    public static String getIdForComponent(String name, ComponentType componentType, ArtifactHolder holder) {
        String idString = holder.getParent() + "@" + holder.getIdString() + ":" + name;
        holder.setHashCode(holder.getHashCode() + idString.hashCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Component : " + idString));
        }
        if (RuntimeStatisticCollector.isOpenTracingEnabled()) {
            ArtifactHolderStore.addStructuringElementStack(idString, holder);
        }
        StatisticIdentityGenerator.process(idString, componentType, holder);
        return idString;
    }

    public static String getIdReferencingComponent(String name, ComponentType componentType, ArtifactHolder holder) {
        String idString = name + "@" + holder.getIdString() + ":" + name + "@indirect";
        holder.setHashCode(holder.getHashCode() + idString.hashCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Referencing Component  : " + idString));
        }
        if (RuntimeStatisticCollector.isOpenTracingEnabled()) {
            ArtifactHolderStore.addStructuringElementStack(idString, holder);
        }
        StatisticIdentityGenerator.process(idString, componentType, holder);
        return idString;
    }

    public static String getIdForFlowContinuableMediator(String mediatorName, ComponentType componentType, ArtifactHolder holder) {
        if (ComponentType.SEQUENCE == componentType && mediatorName.contains("AnonymousSequence")) {
            return null;
        }
        String idString = holder.getParent() + "@" + holder.getIdString() + ":" + mediatorName;
        holder.setHashCode(holder.getHashCode() + idString.hashCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Flow Continuable Mediator : " + idString));
        }
        if (RuntimeStatisticCollector.isOpenTracingEnabled()) {
            ArtifactHolderStore.addStructuringElementStack(idString, holder);
        }
        StatisticIdentityGenerator.process(idString, componentType, holder);
        return idString;
    }

    public static void reportingBranchingEvents(ArtifactHolder holder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starts branching (then/else/targets)");
        }
        holder.setLastParent(holder.getStack().peek().getId());
    }

    public static void reportingEndEvent(String name, ComponentType componentType, ArtifactHolder holder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ending Component Initialization: " + name));
        }
        if (ComponentType.SEQUENCE == componentType || ComponentType.PROXYSERVICE == componentType || ComponentType.API == componentType || ComponentType.RESOURCE == componentType || ComponentType.INBOUNDENDPOINT == componentType) {
            holder.getStack().pop();
            if (!holder.getStack().isEmpty()) {
                holder.setLastParent(holder.getStack().peek().getId());
            }
        }
        if (ComponentType.MEDIATOR == componentType) {
            holder.getStack().pop();
        }
    }

    public static void reportingFlowContinuableEndEvent(String mediatorId, ComponentType mediator, ArtifactHolder holder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ending Flow Continuable Mediator Initialization: " + mediatorId));
        }
        holder.setLastParent(holder.getStack().peek().getId());
        holder.getStack().pop();
        holder.setExitFromBox(true);
    }

    public static void reportingEndBranchingEvent(ArtifactHolder holder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ending Branching Event");
        }
    }

    public static void setSynapseConfiguration(SynapseConfiguration synapseConfiguration) {
        StatisticIdentityGenerator.synapseConfiguration = synapseConfiguration;
    }

    private static void process(String name, ComponentType componentType, ArtifactHolder holder) {
        if (ComponentType.PROXYSERVICE == componentType || ComponentType.API == componentType || ComponentType.INBOUNDENDPOINT == componentType) {
            StructuringElement proxyElem = new StructuringElement(name, componentType);
            holder.getStack().push(proxyElem);
            holder.getList().add(proxyElem);
            holder.setLastParent(name);
        }
        if (ComponentType.SEQUENCE == componentType) {
            StructuringElement seqElem = new StructuringElement(name, componentType);
            if (holder.getStack().isEmpty()) {
                holder.getStack().push(seqElem);
                holder.getList().add(seqElem);
            } else {
                seqElem.setParentId(holder.getLastParent());
                seqElem.setGroup(holder.getStack().peek().getId());
                holder.getStack().push(seqElem);
                holder.getList().add(seqElem);
            }
            holder.setLastParent(name);
        }
        if (ComponentType.RESOURCE == componentType) {
            StructuringElement resourceElem = new StructuringElement(name, componentType);
            resourceElem.setParentId(holder.getStack().peek().getId());
            resourceElem.setGroup(holder.getStack().peek().getId());
            holder.getList().add(resourceElem);
            holder.setLastParent(name);
            holder.getStack().push(resourceElem);
        }
        if (ComponentType.MEDIATOR == componentType) {
            StructuringElement medElem = new StructuringElement(name, componentType);
            if (holder.getExitFromBox()) {
                holder.setExitFromBox(false);
            }
            medElem.setParentId(holder.getLastParent());
            medElem.setGroup(holder.getStack().peek().getId());
            if (holder.getStack().isEmpty()) {
                log.error((Object)("Sequence is missing for mediator : " + name));
            }
            holder.getList().add(medElem);
            holder.setLastParent(name);
            holder.getStack().push(medElem);
        }
        if (ComponentType.ENDPOINT == componentType) {
            StructuringElement endpointElem = new StructuringElement(name, componentType);
            if (!holder.getStack().isEmpty()) {
                endpointElem.setParentId(holder.getStack().peek().getId());
                endpointElem.setGroup(holder.getStack().peek().getId());
            }
            holder.getList().add(endpointElem);
        }
    }
}

