/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.version;

import org.apache.synapse.MessageContext;
import org.apache.synapse.api.API;
import org.apache.synapse.api.ApiUtils;
import org.apache.synapse.api.version.AbstractVersionStrategy;

public class ContextVersionStrategy
extends AbstractVersionStrategy {
    String versionParam;

    public ContextVersionStrategy(API api, String version, String versionParam) {
        super(api, version, "context");
        this.versionParam = versionParam;
        String context = api.getContext();
        context = context.replace("{version}", version);
        api.setContext(context);
    }

    @Override
    public boolean isMatchingVersion(Object versionInfoObj) {
        MessageContext msgContext = (MessageContext)versionInfoObj;
        String path = ApiUtils.getFullRequestPath(msgContext);
        String context = this.getAPI().getContext();
        return path.startsWith(context);
    }

    @Override
    public String getVersionParam() {
        return this.versionParam;
    }
}

