/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.rest;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.api.API;
import org.apache.synapse.api.AbstractApiHandler;
import org.apache.synapse.api.ApiConstants;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class RestRequestHandler
extends AbstractApiHandler {
    private static final Log log = LogFactory.getLog(RestRequestHandler.class);

    @Override
    public boolean process(MessageContext synCtx) {
        if (synCtx.isResponse()) {
            return this.dispatchToAPI(synCtx);
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String protocol = msgCtx.getIncomingTransportName();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid protocol for REST API mediation: " + protocol));
            }
            return false;
        }
        return this.dispatchToAPI(synCtx);
    }

    @Override
    protected boolean dispatchToAPI(MessageContext synCtx) {
        Object apiObject = synCtx.getProperty("PROCESSED_API");
        Collection<API> apis = apiObject != null ? Collections.singletonList((API)apiObject) : synCtx.getEnvironment().getSynapseConfiguration().getAPIs(ApiConstants.DEFAULT_BINDING_ENDPOINT_NAME);
        if (!apis.isEmpty()) {
            return this.dispatchToAPI(apis, synCtx);
        }
        return false;
    }
}

