/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.inbound;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.API;
import org.apache.synapse.api.ApiConstants;
import org.apache.synapse.api.Resource;

public class InboundApiUtils {
    private static final Log log = LogFactory.getLog(InboundApiUtils.class);

    private InboundApiUtils() {
    }

    public static void addBindsTo(API api, OMElement omElement) {
        api.addAllBindsTo(InboundApiUtils.extractBindsTo(omElement));
    }

    public static void addBindsTo(Resource resource, OMElement omElement) {
        resource.addAllBindsTo(InboundApiUtils.extractBindsTo(omElement));
    }

    private static Set<String> extractBindsTo(OMElement omElement) {
        OMAttribute bindsToAttribute = omElement.getAttribute(new QName(ApiConstants.BINDS_TO));
        HashSet<String> bindsTo = new HashSet<String>();
        if (bindsToAttribute != null) {
            String[] inboundEndpointNames;
            for (String inboundEndpointName : inboundEndpointNames = bindsToAttribute.getAttributeValue().split(",")) {
                String trimmedInboundEndpointName = inboundEndpointName.trim();
                if (trimmedInboundEndpointName.isEmpty()) continue;
                bindsTo.add(trimmedInboundEndpointName);
            }
        }
        return bindsTo;
    }

    private static void validateBindsTo(API api, Resource resource) {
        if (!api.getBindsTo().containsAll(resource.getBindsTo())) {
            InboundApiUtils.handleException("A resource definition's 'binds-to' must be a subset of its API definition's 'binds-to'");
        }
    }

    public static void populateBindsTo(API api) {
        if (api.getBindsTo().isEmpty()) {
            api.addBindsTo(ApiConstants.DEFAULT_BINDING_ENDPOINT_NAME);
        }
        for (Resource resource : api.getResources()) {
            if (resource.getBindsTo().isEmpty()) {
                resource.addAllBindsTo(api.getBindsTo());
                continue;
            }
            InboundApiUtils.validateBindsTo(api, resource);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

