/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.dispatch;

import org.apache.synapse.api.ApiUtils;
import org.apache.synapse.api.dispatch.DispatcherHelper;

public class URLMappingHelper
implements DispatcherHelper {
    private String[] pathSegments;
    private String extension;
    private String exactMatch;

    public URLMappingHelper(String urlMapping) {
        if (urlMapping.startsWith("/") && urlMapping.endsWith("/*")) {
            this.pathSegments = urlMapping.length() > 2 ? urlMapping.substring(1, urlMapping.length() - 2).split("/") : new String[0];
        } else if (urlMapping.startsWith("*.")) {
            this.extension = urlMapping.substring(1);
        } else {
            this.exactMatch = urlMapping.length() > 1 && urlMapping.endsWith("/") ? urlMapping.substring(0, urlMapping.length() - 1) : urlMapping;
        }
    }

    public boolean isExactMatch(String url) {
        int index;
        if (!"/".equals(url)) {
            url = ApiUtils.trimTrailingSlashes(url);
        }
        if ((index = url.indexOf(63)) > 0) {
            url = url.substring(0, index);
        } else if (index == 0) {
            url = "/";
        }
        return this.exactMatch != null && this.exactMatch.equals(url);
    }

    public boolean isExtensionMatch(String url) {
        int index = url.indexOf(63);
        if (index != -1) {
            url = url.substring(0, index);
        }
        return this.extension != null && url.endsWith(this.extension);
    }

    public int getPrefixMatchingLength(String url) {
        if (this.pathSegments != null) {
            if (this.pathSegments.length == 0) {
                return 1;
            }
            int index = (url = ApiUtils.trimSlashes(url)).indexOf(63);
            if (index != -1) {
                url = url.substring(0, index);
            }
            String[] segments = url.split("/");
            int matchingLength = 0;
            for (int i = 0; i < this.pathSegments.length; ++i) {
                if (segments.length > i) {
                    if (segments[i].equals(this.pathSegments[i])) {
                        ++matchingLength;
                        continue;
                    }
                    return 0;
                }
                return 0;
            }
            return matchingLength;
        }
        return 0;
    }

    @Override
    public String getString() {
        if (this.pathSegments != null) {
            StringBuilder str = new StringBuilder("");
            for (String segment : this.pathSegments) {
                str.append("/").append(segment);
            }
            return str.append("/*").toString();
        }
        if (this.extension != null) {
            return "*." + this.extension;
        }
        return this.exactMatch;
    }
}

