/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.dispatch;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.api.ApiUtils;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.RESTDispatcher;
import org.apache.synapse.api.dispatch.URITemplateHelper;

public class URITemplateBasedDispatcher
implements RESTDispatcher {
    @Override
    public Resource findResource(MessageContext synCtx, Collection<Resource> resources) {
        String url = ApiUtils.getSubRequestPath(synCtx);
        for (Resource r : resources) {
            DispatcherHelper helper = r.getDispatcherHelper();
            if (!(helper instanceof URITemplateHelper)) continue;
            URITemplateHelper templateHelper = (URITemplateHelper)helper;
            HashMap variables = new HashMap();
            if (!templateHelper.getUriTemplate().matches(url, variables)) continue;
            for (Map.Entry entry : variables.entrySet()) {
                synCtx.setProperty("uri.var." + (String)entry.getKey(), entry.getValue());
            }
            return r;
        }
        return null;
    }
}

