/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.cors;

import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.cors.CORSConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;

public class SynapseCORSConfiguration
implements CORSConfiguration {
    private static Log LOG = LogFactory.getLog(SynapseCORSConfiguration.class);
    private static SynapseCORSConfiguration corsConfigs = null;
    private boolean enabled;
    private Set<String> allowedOrigins = new HashSet<String>();
    private String allowedHeaders;
    private static final String LOCAL_HOST = "localhost";

    private SynapseCORSConfiguration() {
        this.enabled = SynapsePropertiesLoader.getBooleanProperty("synapse.rest.CORSConfig.enabled", true);
        if (!this.enabled) {
            return;
        }
        String allowedOriginListStr = SynapsePropertiesLoader.getPropertyValue("synapse.rest.CORSConfig.Access-Control-Allow-Origin", null);
        if (allowedOriginListStr != null) {
            String[] originList;
            for (String origin : originList = allowedOriginListStr.split(",")) {
                String trimmedOrigin = origin.trim();
                this.allowedOrigins.add(trimmedOrigin);
                if (!trimmedOrigin.contains(LOCAL_HOST)) continue;
                try {
                    URL url = new URL(trimmedOrigin);
                    if (!url.getHost().equals(LOCAL_HOST)) continue;
                    Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (networkInterfaces.hasMoreElements()) {
                        NetworkInterface nInterface = networkInterfaces.nextElement();
                        for (InterfaceAddress iAddr : nInterface.getInterfaceAddresses()) {
                            URL localUrl = new URL(url.getProtocol(), iAddr.getAddress().getHostAddress(), url.getPort(), "");
                            this.allowedOrigins.add(localUrl.toString());
                        }
                    }
                }
                catch (MalformedURLException e) {
                    throw new SynapseException("Provided origin URL " + trimmedOrigin + " is malformed", e);
                }
                catch (SocketException e) {
                    throw new SynapseException("Error occurred while retrieving network interfaces", e);
                }
            }
        }
        this.allowedHeaders = SynapsePropertiesLoader.getPropertyValue("synapse.rest.CORSConfig.Access-Control-Allow-Headers", "");
    }

    public static SynapseCORSConfiguration getInstance() {
        if (corsConfigs != null) {
            return corsConfigs;
        }
        corsConfigs = new SynapseCORSConfiguration();
        return corsConfigs;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @Override
    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }
}

