/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api.cors;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.api.cors.CORSConfiguration;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class CORSHelper {
    private static final Log log = LogFactory.getLog(CORSHelper.class);

    public static String getAllowedOrigins(String origin, Set<String> allowedOrigins) {
        if (allowedOrigins.contains("*")) {
            return "*";
        }
        if (allowedOrigins.contains(origin)) {
            return origin;
        }
        return null;
    }

    public static void handleCORSHeaders(CORSConfiguration corsConfiguration, MessageContext synCtx, String supportedMethods, boolean updateHeaders) {
        org.apache.axis2.context.MessageContext msgCtx;
        Map transportHeaders;
        if (corsConfiguration.isEnabled() && (transportHeaders = (Map)(msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null) {
            String allowedOrigin = CORSHelper.getAllowedOrigins((String)transportHeaders.get("Origin"), corsConfiguration.getAllowedOrigins());
            if (updateHeaders) {
                transportHeaders.put("Access-Control-Allow-Methods", supportedMethods);
                transportHeaders.put("Access-Control-Allow-Origin", allowedOrigin);
                transportHeaders.put("Access-Control-Allow-Headers", corsConfiguration.getAllowedHeaders());
            }
            synCtx.setProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Methods", supportedMethods);
            synCtx.setProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Origin", allowedOrigin);
            synCtx.setProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Headers", corsConfiguration.getAllowedHeaders());
            synCtx.setProperty("_SYNAPSE_INTERNAL_REST_Origin", transportHeaders.get("Origin"));
        }
    }

    public static void handleCORSHeadersForResponse(CORSConfiguration corsConfiguration, MessageContext synCtx) {
        org.apache.axis2.context.MessageContext msgCtx;
        Map transportHeaders;
        if (corsConfiguration.isEnabled() && (transportHeaders = (Map)(msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null) {
            if (synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Methods") != null) {
                transportHeaders.put("Access-Control-Allow-Methods", (String)synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Methods"));
            }
            if (synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Origin") != null) {
                transportHeaders.put("Access-Control-Allow-Origin", (String)synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Origin"));
            }
            if (synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Headers") != null) {
                transportHeaders.put("Access-Control-Allow-Headers", (String)synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Access-Control-Allow-Headers"));
            }
            if (synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Origin") != null) {
                transportHeaders.put("Origin", (String)synCtx.getProperty("_SYNAPSE_INTERNAL_REST_Origin"));
            }
        }
    }
}

