/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.util.UIDGenerator;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.AbstractRequestProcessor;
import org.apache.synapse.api.ApiUtils;
import org.apache.synapse.api.cors.CORSHelper;
import org.apache.synapse.api.cors.SynapseCORSConfiguration;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.RESTConstants;

public class Resource
extends AbstractRequestProcessor
implements ManagedLifecycle,
AspectConfigurable {
    private Set<String> methods = new HashSet<String>(4);
    private String contentType;
    private String userAgent;
    private int protocol = 0;
    AspectConfiguration aspectConfiguration;
    private Set<String> bindsTo = new HashSet<String>();
    private SequenceMediator inSequence;
    private SequenceMediator outSequence;
    private SequenceMediator faultSequence;
    private String inSequenceKey;
    private String outSequenceKey;
    private String faultSequenceKey;
    private DispatcherHelper dispatcherHelper;

    public Resource() {
        super(UIDGenerator.generateUID());
    }

    public String getName() {
        return this.name;
    }

    public SequenceMediator getInSequence() {
        return this.inSequence;
    }

    public void setInSequence(SequenceMediator inSequence) {
        this.inSequence = inSequence;
    }

    public SequenceMediator getOutSequence() {
        return this.outSequence;
    }

    public void setOutSequence(SequenceMediator outSequence) {
        this.outSequence = outSequence;
    }

    public String getInSequenceKey() {
        return this.inSequenceKey;
    }

    public void setInSequenceKey(String inSequenceKey) {
        this.inSequenceKey = inSequenceKey;
    }

    public String getOutSequenceKey() {
        return this.outSequenceKey;
    }

    public void setOutSequenceKey(String outSequenceKey) {
        this.outSequenceKey = outSequenceKey;
    }

    public SequenceMediator getFaultSequence() {
        return this.faultSequence;
    }

    public void setFaultSequence(SequenceMediator faultSequence) {
        this.faultSequence = faultSequence;
    }

    public String getFaultSequenceKey() {
        return this.faultSequenceKey;
    }

    public void setFaultSequenceKey(String faultSequenceKey) {
        this.faultSequenceKey = faultSequenceKey;
    }

    public boolean addMethod(String method) {
        for (RESTConstants.METHODS allowedMethod : RESTConstants.METHODS.values()) {
            if (!allowedMethod.name().equals(method)) continue;
            this.methods.add(method);
            return true;
        }
        return false;
    }

    public String[] getMethods() {
        return this.methods.toArray(new String[this.methods.size()]);
    }

    public boolean hasMatchingMethod(String method) {
        if ("OPTIONS".equals(method)) {
            return true;
        }
        if (!this.methods.isEmpty() && !this.methods.contains(method)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"HTTP method does not match");
            }
            return false;
        }
        return true;
    }

    public DispatcherHelper getDispatcherHelper() {
        return this.dispatcherHelper;
    }

    public void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.dispatcherHelper = dispatcherHelper;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (contentType.indexOf(47) == -1 || contentType.split("/").length != 2) {
            throw new SynapseException("Invalid content type: " + contentType);
        }
        this.contentType = contentType;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public Set<String> getBindsTo() {
        return this.bindsTo;
    }

    public void addAllBindsTo(Set<String> inboundEndpointBindings) {
        this.bindsTo.addAll(inboundEndpointBindings);
    }

    @Override
    boolean canProcess(MessageContext synCtx) {
        String agent;
        String type;
        boolean hasPayload;
        if (synCtx.isResponse()) {
            return true;
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (this.protocol == 1 && !"http".equals(msgCtx.getIncomingTransportName())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Protocol information does not match - Expected HTTP");
            }
            return false;
        }
        if (this.protocol == 2 && !"https".equals(msgCtx.getIncomingTransportName())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Protocol information does not match - Expected HTTPS");
            }
            return false;
        }
        String method = (String)msgCtx.getProperty("HTTP_METHOD");
        synCtx.setProperty("REST_METHOD", method);
        if ("OPTIONS".equals(method)) {
            return true;
        }
        if (!this.methods.isEmpty() && !this.methods.contains(method)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"HTTP method does not match");
            }
            return false;
        }
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if ((this.contentType != null || this.userAgent != null) && transportHeaders == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Transport headers not available on the message");
            }
            return false;
        }
        boolean bl = hasPayload = !Boolean.TRUE.equals(msgCtx.getProperty("NO_ENTITY_BODY"));
        if (this.contentType != null && hasPayload && !this.contentType.equals(type = (String)transportHeaders.get("Content-Type"))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Content type does not match - Expected: " + this.contentType + ", Found: " + type));
            }
            return false;
        }
        if (!(this.userAgent == null || (agent = (String)transportHeaders.get("User-Agent")) != null && agent.matches(this.userAgent))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("User agent does not match - Expected: " + this.userAgent + ", Found: " + agent));
            }
            return false;
        }
        return true;
    }

    @Override
    void process(MessageContext synCtx) {
        String sequenceKey;
        SequenceMediator sequence;
        Integer statisticReportingIndex = null;
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (!synCtx.isResponse() && this.getDispatcherHelper() != null) {
            synCtx.setProperty("rest.url.pattern", this.getDispatcherHelper().getString());
        }
        if (isStatisticsEnabled) {
            statisticReportingIndex = OpenEventCollector.reportChildEntryEvent(synCtx, Resource.getResourceName(synCtx, this.name), ComponentType.RESOURCE, this.getAspectConfiguration(), true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing message with ID: " + synCtx.getMessageID() + " through the resource: " + this.name));
        }
        if (!synCtx.isResponse()) {
            String method = (String)synCtx.getProperty("REST_METHOD");
            if ("OPTIONS".equals(method) && this.sendOptions(synCtx)) {
                if (isStatisticsEnabled) {
                    CloseEventCollector.closeEntryEvent(synCtx, Resource.getResourceName(synCtx, this.name), ComponentType.RESOURCE, statisticReportingIndex, true);
                }
                return;
            }
            CORSHelper.handleCORSHeaders(SynapseCORSConfiguration.getInstance(), synCtx, this.getSupportedMethods(), false);
            synCtx.setProperty("SYNAPSE_RESOURCE", this.name);
            ApiUtils.populateQueryParamsToMessageContext(synCtx);
        } else {
            CORSHelper.handleCORSHeadersForResponse(SynapseCORSConfiguration.getInstance(), synCtx);
        }
        SequenceMediator sequenceMediator = sequence = synCtx.isResponse() ? this.outSequence : this.inSequence;
        if (sequence != null) {
            this.registerFaultHandler(synCtx);
            sequence.mediate(synCtx);
            if (isStatisticsEnabled) {
                CloseEventCollector.closeEntryEvent(synCtx, Resource.getResourceName(synCtx, this.name), ComponentType.RESOURCE, statisticReportingIndex, true);
            }
            return;
        }
        String string = sequenceKey = synCtx.isResponse() ? this.outSequenceKey : this.inSequenceKey;
        if (sequenceKey != null) {
            this.registerFaultHandler(synCtx);
            Mediator referredSequence = synCtx.getSequence(sequenceKey);
            if (referredSequence == null) {
                throw new SynapseException("Specified sequence: " + sequenceKey + " cannot be found");
            }
            referredSequence.mediate(synCtx);
            if (isStatisticsEnabled) {
                CloseEventCollector.closeEntryEvent(synCtx, Resource.getResourceName(synCtx, this.name), ComponentType.RESOURCE, statisticReportingIndex, true);
            }
            return;
        }
        if (synCtx.isResponse()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No out-sequence configured. Sending the response back.");
            }
            this.registerFaultHandler(synCtx);
            Axis2Sender.sendBack(synCtx);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"No in-sequence configured. Dropping the request.");
        }
        if (isStatisticsEnabled) {
            CloseEventCollector.closeEntryEvent(synCtx, Resource.getResourceName(synCtx, this.name), ComponentType.RESOURCE, statisticReportingIndex, true);
        }
    }

    public void registerFaultHandler(MessageContext synCtx) {
        if (this.faultSequence != null) {
            synCtx.pushFaultHandler(new MediatorFaultHandler(this.faultSequence));
        } else if (this.faultSequenceKey != null) {
            Mediator faultSequence = synCtx.getSequence(this.faultSequenceKey);
            if (faultSequence != null) {
                synCtx.pushFaultHandler(new MediatorFaultHandler(faultSequence));
            } else {
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            }
        } else {
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
        }
    }

    private boolean sendOptions(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (this.methods.contains("OPTIONS")) {
            String maxForwardsHeader = (String)transportHeaders.get("Max-Forwards");
            if (maxForwardsHeader != null) {
                int maxForwards = Integer.parseInt(maxForwardsHeader);
                if (maxForwards == 0) {
                    synCtx.setResponse(true);
                    synCtx.setTo(null);
                    transportHeaders.put("Allow", this.getSupportedMethods());
                    CORSHelper.handleCORSHeaders(SynapseCORSConfiguration.getInstance(), synCtx, this.getSupportedMethods(), true);
                    Axis2Sender.sendBack(synCtx);
                    return true;
                }
                transportHeaders.put("Max-Forwards", String.valueOf(maxForwards - 1));
            }
            return false;
        }
        synCtx.setResponse(true);
        synCtx.setTo(null);
        transportHeaders.put("Allow", this.getSupportedMethods());
        CORSHelper.handleCORSHeaders(SynapseCORSConfiguration.getInstance(), synCtx, this.getSupportedMethods(), true);
        Axis2Sender.sendBack(synCtx);
        return true;
    }

    private String getSupportedMethods() {
        StringBuilder value = new StringBuilder("");
        if (this.methods.isEmpty()) {
            value.append("GET, POST, PUT, DELETE");
        } else {
            for (String method : this.methods) {
                if ("OPTIONS".equals(method)) continue;
                if (value.length() > 0) {
                    value.append(", ");
                }
                value.append(method);
            }
        }
        return value.toString();
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing resource with ID: " + this.name));
        }
        if (this.inSequence != null) {
            this.inSequence.init(se);
        }
        if (this.outSequence != null) {
            this.outSequence.init(se);
        }
        if (this.faultSequence != null) {
            this.faultSequence.init(se);
        }
    }

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying resource with ID: " + this.name));
        }
        if (this.inSequence != null && this.inSequence.isInitialized()) {
            this.inSequence.destroy();
        }
        if (this.outSequence != null && this.outSequence.isInitialized()) {
            this.outSequence.destroy();
        }
        if (this.faultSequence != null && this.faultSequence.isInitialized()) {
            this.faultSequence.destroy();
        }
    }

    private static String getResourceName(MessageContext messageContext, String resourceId) {
        Object synapseRestApi = messageContext.getProperty("REST_API_CONTEXT");
        Object restUrlPattern = messageContext.getProperty("rest.url.pattern");
        if (synapseRestApi != null) {
            String textualStringName = restUrlPattern != null ? (String)synapseRestApi + restUrlPattern : (String)synapseRestApi;
            return textualStringName;
        }
        return resourceId;
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public void setComponentStatisticsId(ArtifactHolder holder) {
        StatisticIdentityGenerator.reportingBranchingEvents(holder);
        if (this.aspectConfiguration == null) {
            this.aspectConfiguration = new AspectConfiguration(this.name);
        }
        String resourceId = StatisticIdentityGenerator.getIdForComponent(this.getResourceClassName(), ComponentType.RESOURCE, holder);
        this.aspectConfiguration.setUniqueId(resourceId);
        String childId = null;
        if (this.inSequenceKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.inSequenceKey, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.inSequence != null) {
            this.inSequence.setComponentStatisticsId(holder);
        }
        if (this.outSequenceKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.outSequenceKey, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.outSequence != null) {
            this.outSequence.setComponentStatisticsId(holder);
        }
        if (this.faultSequenceKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.faultSequenceKey, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.faultSequence != null) {
            this.faultSequence.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(resourceId, ComponentType.RESOURCE, holder);
    }

    public String getResourceClassName() {
        String cls = this.getClass().getName();
        return cls.substring(cls.lastIndexOf(".") + 1);
    }
}

