/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.dispatch.DefaultDispatcher;
import org.apache.synapse.api.dispatch.RESTDispatcher;
import org.apache.synapse.api.dispatch.URITemplateBasedDispatcher;
import org.apache.synapse.api.dispatch.URLMappingBasedDispatcher;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class ApiUtils {
    private static final Log log = LogFactory.getLog(ApiUtils.class);
    private static final List<RESTDispatcher> dispatchers = new ArrayList<RESTDispatcher>();

    public static String trimSlashes(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.startsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String trimTrailingSlashes(String url) {
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getFullRequestPath(MessageContext synCtx) {
        Object obj = synCtx.getProperty("REST_FULL_REQUEST_PATH");
        if (obj != null) {
            return (String)obj;
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String url = (String)msgCtx.getProperty("TransportInURL");
        if (url == null) {
            url = (String)synCtx.getProperty("SERVICE_PREFIX");
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                url = new URL(url).getFile();
            }
            catch (MalformedURLException e) {
                ApiUtils.handleException("Request URL: " + url + " is malformed", e);
            }
        } else if (url.startsWith("ws://") || url.startsWith("wss://")) {
            try {
                URI uri = new URI(url);
                String query = uri.getQuery();
                url = query == null ? uri.getPath() : uri.getPath() + "?" + query;
            }
            catch (URISyntaxException e) {
                ApiUtils.handleException("Request URL: " + url + " is malformed", e);
            }
        }
        synCtx.setProperty("REST_FULL_REQUEST_PATH", url);
        return url;
    }

    public static void populateQueryParamsToMessageContext(MessageContext synCtx) {
        String path = ApiUtils.getFullRequestPath(synCtx);
        String method = (String)synCtx.getProperty("REST_METHOD");
        int queryIndex = path.indexOf(63);
        if (queryIndex != -1) {
            String query = path.substring(queryIndex + 1);
            String[] entries = query.split("&");
            String name = null;
            for (String entry : entries) {
                String value;
                int index = entry.indexOf(61);
                if (index != -1) {
                    try {
                        name = entry.substring(0, index);
                        value = URLDecoder.decode(entry.substring(index + 1), "UTF-8");
                        synCtx.setProperty("query.param." + name, value);
                    }
                    catch (UnsupportedEncodingException uee) {
                        ApiUtils.handleException("Error processing " + method + " request for : " + path, uee);
                    }
                    catch (IllegalArgumentException e) {
                        String errorMessage = "Error processing " + method + " request for : " + path + " due to an error in the request sent by the client";
                        synCtx.setProperty("ERROR_CODE", 400);
                        synCtx.setProperty("ERROR_MESSAGE", errorMessage);
                        org.apache.axis2.context.MessageContext inAxisMsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                        inAxisMsgCtx.setProperty("HTTP_SC", (Object)400);
                        ApiUtils.handleException(errorMessage, e);
                    }
                    continue;
                }
                String existingValue = (String)synCtx.getProperty("query.param." + name);
                value = "&" + entry;
                synCtx.setProperty("query.param." + name, existingValue + value);
            }
        }
    }

    public static String getSubRequestPath(MessageContext synCtx) {
        return (String)synCtx.getProperty("REST_SUB_REQUEST_PATH");
    }

    public static List<RESTDispatcher> getDispatchers() {
        return dispatchers;
    }

    private static void handleException(String msg, Throwable t) {
        log.error((Object)msg, t);
        throw new SynapseException(msg, t);
    }

    public static boolean matchApiPath(String path, String context) {
        return path.startsWith(context + "/") || path.startsWith(context + "?") || context.equals(path) || "/".equals(context);
    }

    static {
        dispatchers.add(new URLMappingBasedDispatcher());
        dispatchers.add(new URITemplateBasedDispatcher());
        dispatchers.add(new DefaultDispatcher());
    }
}

